/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.cap;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.shrink.api.IShrinkProvider;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.network.PacketHandler;
import net.gigabit101.shrink.network.PacketShrink;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;

public final class ShrinkImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IShrinkProvider.class, (Capability.IStorage)new Capability.IStorage<IShrinkProvider>(){

            public CompoundNBT writeNBT(Capability<IShrinkProvider> capability, IShrinkProvider instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IShrinkProvider> capability, IShrinkProvider instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> new DefaultImpl(null));
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        public static final ResourceLocation NAME = new ResourceLocation("shrink", "shrunk");
        private final DefaultImpl impl;
        private final LazyOptional<IShrinkProvider> cap;

        public Provider(LivingEntity livingEntity) {
            this.impl = new DefaultImpl(livingEntity);
            this.cap = LazyOptional.of(() -> this.impl);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
            if (capability == ShrinkAPI.SHRINK_CAPABILITY) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements IShrinkProvider {
        private final LivingEntity livingEntity;
        private boolean isShrunk = false;
        private EntitySize defaultEntitySize;
        private float defaultEyeHeight;
        private float scale = 1.0f;
        private boolean isShrinking = false;

        private DefaultImpl(@Nullable LivingEntity livingEntity) {
            this.livingEntity = livingEntity;
            this.defaultEntitySize = livingEntity.field_213325_aI;
            this.defaultEyeHeight = livingEntity.field_213326_aJ;
        }

        @Override
        public boolean isShrunk() {
            return this.isShrunk;
        }

        @Override
        public boolean isShrinking() {
            return this.isShrinking;
        }

        @Override
        public void setShrinking(boolean value) {
            this.isShrinking = value;
        }

        @Override
        public void setShrunk(boolean isShrunk) {
            if (this.isShrunk != isShrunk) {
                this.isShrunk = isShrunk;
                this.sync(this.livingEntity);
            }
        }

        @Override
        public void sync(@Nonnull LivingEntity livingEntity) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), new PacketShrink(livingEntity.func_145782_y(), this.serializeNBT()));
        }

        @Override
        public void shrink(@Nonnull LivingEntity livingEntity) {
            this.setShrinking(true);
            if (this.defaultEntitySize == null) {
                this.defaultEntitySize = livingEntity.field_213325_aI;
            }
            if (this.defaultEyeHeight == 0.0f) {
                this.defaultEyeHeight = livingEntity.field_213326_aJ;
            }
            livingEntity.func_213323_x_();
            this.setShrunk(true);
            this.sync(livingEntity);
        }

        @Override
        public void deShrink(@Nonnull LivingEntity livingEntity) {
            this.setShrunk(false);
            livingEntity.func_213323_x_();
            this.sync(livingEntity);
        }

        @Override
        public EntitySize defaultEntitySize() {
            return this.defaultEntitySize;
        }

        @Override
        public float defaultEyeHeight() {
            return this.defaultEyeHeight;
        }

        @Override
        public float scale() {
            return this.scale;
        }

        @Override
        public void setScale(float scale) {
            if (this.scale != scale) {
                this.scale = scale;
                this.sync(this.livingEntity);
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT properties = new CompoundNBT();
            properties.func_74757_a("isshrunk", this.isShrunk);
            properties.func_74776_a("width", this.defaultEntitySize.field_220315_a);
            properties.func_74776_a("height", this.defaultEntitySize.field_220316_b);
            properties.func_74757_a("fixed", this.defaultEntitySize.field_220317_c);
            properties.func_74776_a("defaulteyeheight", this.defaultEyeHeight);
            properties.func_74776_a("scale", this.scale);
            properties.func_74757_a("isshrinking", this.isShrinking);
            return properties;
        }

        public void deserializeNBT(CompoundNBT properties) {
            this.isShrunk = properties.func_74767_n("isshrunk");
            this.defaultEntitySize = new EntitySize(properties.func_74760_g("width"), properties.func_74760_g("height"), properties.func_74767_n("fixed"));
            this.defaultEyeHeight = properties.func_74760_g("defaulteyeheight");
            this.scale = properties.func_74760_g("scale");
            this.isShrinking = properties.func_74767_n("isshrinking");
        }
    }
}

