/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MapDecorationHandler {
    private static final Map<String, CustomDecorationType<?, ?>> DECORATION_TYPES = new HashMap();
    public static final CustomDecorationType<?, ?> GENERIC_STRUCTURE_TYPE = MapDecorationHandler.makeSimpleType("selene", "generic_structure");

    public static void register(CustomDecorationType<?, ?> newType) {
        String id = newType.getRegistryId();
        if (DECORATION_TYPES.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate map decoration registration " + id);
        }
        DECORATION_TYPES.put(id, newType);
    }

    public static void registerSimple(String modId, String name) {
        MapDecorationHandler.register(MapDecorationHandler.makeSimpleType(modId, name));
    }

    public static CustomDecorationType<?, ?> makeSimpleType(String modId, String name) {
        return new CustomDecorationType(new ResourceLocation(modId, name), CustomDecoration::new);
    }

    @Nullable
    public static CustomDecorationType<?, ?> get(ResourceLocation id) {
        return MapDecorationHandler.get(id.toString());
    }

    @Nullable
    public static CustomDecorationType<?, ?> get(String id) {
        return DECORATION_TYPES.get(id);
    }

    @Nullable
    public static MapWorldMarker<?> readWorldMarker(CompoundNBT compound) {
        for (String s : DECORATION_TYPES.keySet()) {
            if (!compound.func_74764_b(s)) continue;
            return DECORATION_TYPES.get(s).loadMarkerFromNBT(compound.func_74775_l(s));
        }
        return null;
    }

    public static List<MapWorldMarker<?>> getMarkersFromWorld(IBlockReader reader, BlockPos pos) {
        ArrayList list = new ArrayList();
        for (CustomDecorationType<?, ?> type : DECORATION_TYPES.values()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapWorldMarker<?>)c);
        }
        return list;
    }

    public static void addTargetDecoration(ItemStack stack, BlockPos pos, CustomDecorationType<?, ?> type, int mapColor) {
        ListNBT listnbt;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomDecorations", 9)) {
            listnbt = stack.func_77978_p().func_150295_c("CustomDecorations", 10);
        } else {
            listnbt = new ListNBT();
            stack.func_77983_a("CustomDecorations", (INBT)listnbt);
        }
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("type", type.getRegistryId());
        compoundnbt.func_74768_a("x", pos.func_177958_n());
        compoundnbt.func_74768_a("z", pos.func_177952_p());
        listnbt.add((Object)compoundnbt);
        if (mapColor != 0) {
            CompoundNBT com = stack.func_190925_c("display");
            com.func_74768_a("MapColor", mapColor);
        }
    }

    public static void addTargetDecoration(ItemStack stack, BlockPos pos, ResourceLocation id, int mapColor) {
        CustomDecorationType<?, ?> type = DECORATION_TYPES.getOrDefault(id.toString(), GENERIC_STRUCTURE_TYPE);
        MapDecorationHandler.addTargetDecoration(stack, pos, type, mapColor);
    }
}

