/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.Settings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum ScanFilterIgnoredBlocks {
    INSTANCE;

    private Set<Block> filter;

    public static boolean shouldIgnore(BlockState state) {
        INSTANCE.validateFilter();
        return ScanFilterIgnoredBlocks.INSTANCE.filter.contains(state.func_177230_c());
    }

    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        HashSet<Block> ignoredBlocks = new HashSet<Block>();
        for (ResourceLocation location : Settings.ignoredBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            ignoredBlocks.add(block);
        }
        ArrayList<ITag> ignoredTags = new ArrayList<ITag>();
        for (ResourceLocation location : Settings.ignoredBlockTags) {
            ITag tag2 = BlockTags.func_199896_a().func_199910_a(location);
            if (tag2 == null) continue;
            ignoredTags.add(tag2);
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState blockState = block.func_176223_P();
            if (!ignoredTags.stream().anyMatch(tag -> tag.func_230235_a_((Object)block))) continue;
            ignoredBlocks.add(blockState.func_177230_c());
        }
        this.filter = ignoredBlocks;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        ScanFilterIgnoredBlocks.INSTANCE.filter = null;
    }
}

