/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import li.cil.scannable.api.API;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModuleBlock;
import li.cil.scannable.client.scanning.filter.ScanFilterBlockCache;
import li.cil.scannable.client.scanning.filter.ScanFilterFluidTag;
import li.cil.scannable.common.config.Settings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum ScannerModuleFluid implements ScannerModuleBlock
{
    INSTANCE;

    @OnlyIn(value=Dist.CLIENT)
    private ScanFilterBlock filter;

    @Override
    public int getEnergyCost(PlayerEntity player, ItemStack module) {
        return Settings.energyCostModuleFluid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)GameRegistry.findRegistry(ScanResultProvider.class).getValue(API.SCAN_RESULT_PROVIDER_BLOCKS);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<ScanFilterBlock> getFilter(ItemStack module) {
        this.validateFilter();
        return Optional.of(this.filter);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<ScanFilterBlock> filters = new ArrayList<ScanFilterBlock>();
        for (ITag.INamedTag tag : FluidTags.func_241280_c_()) {
            if (Settings.ignoredFluidTags.contains(tag.func_230234_a_())) continue;
            filters.add(new ScanFilterFluidTag((ITag<Fluid>)tag));
        }
        this.filter = new ScanFilterBlockCache((Collection<ScanFilterBlock>)filters);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        ScannerModuleFluid.INSTANCE.filter = null;
    }
}

