/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.container.EntityModuleContainerProvider;
import li.cil.scannable.common.item.AbstractItemScannerModuleEntity;
import li.cil.scannable.common.scanning.ScannerModuleEntityConfigurable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public final class ItemScannerModuleEntityConfigurable
extends AbstractItemScannerModuleEntity {
    private static final String TAG_ENTITY_DEPRECATED = "entity";
    private static final String TAG_ENTITIES = "entities";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(TAG_IS_LOCKED);
    }

    public static List<EntityType<?>> getEntityTypes(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_ENTITY_DEPRECATED, 8) && !nbt.func_150297_b(TAG_ENTITIES, 9)) {
            return Collections.emptyList();
        }
        ItemScannerModuleEntityConfigurable.upgradeData(nbt);
        ListNBT list = nbt.func_150295_c(TAG_ENTITIES, 8);
        ArrayList result = new ArrayList();
        list.forEach(tag -> {
            Optional entityType = EntityType.func_220327_a((String)tag.func_150285_a_());
            entityType.ifPresent(result::add);
        });
        return result;
    }

    private static boolean addEntityType(ItemStack stack, EntityType<?> entityType) {
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return false;
        }
        StringNBT itemNbt = StringNBT.func_229705_a_((String)registryName.toString());
        ListNBT list = nbt.func_150295_c(TAG_ENTITIES, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        nbt.func_218657_a(TAG_ENTITIES, (INBT)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static boolean setEntityTypeAt(ItemStack stack, int index, EntityType<?> entityType) {
        if (index < 0 || index >= 5) {
            return false;
        }
        ResourceLocation registryName = entityType.getRegistryName();
        if (registryName == null) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return false;
        }
        StringNBT itemNbt = StringNBT.func_229705_a_((String)registryName.toString());
        ListNBT list = nbt.func_150295_c(TAG_ENTITIES, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return true;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.set(index, (INBT)itemNbt);
        }
        if (oldIndex >= 0) {
            list.remove(oldIndex);
        }
        return true;
    }

    public static void removeEntityTypeAt(ItemStack stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return;
        }
        ListNBT list = nbt.func_150295_c(TAG_ENTITIES, 8);
        if (index < list.size()) {
            list.remove(index);
        }
    }

    private static void upgradeData(CompoundNBT nbt) {
        if (nbt.func_150297_b(TAG_ENTITY_DEPRECATED, 8)) {
            ListNBT list = new ListNBT();
            list.add((Object)nbt.func_74781_a(TAG_ENTITY_DEPRECATED));
            nbt.func_218657_a(TAG_ENTITIES, (INBT)list);
            nbt.func_82580_o(TAG_ENTITY_DEPRECATED);
        }
    }

    public ItemScannerModuleEntityConfigurable() {
        super(ScannerModuleEntityConfigurable.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        List<EntityType<?>> entities = ItemScannerModuleEntityConfigurable.getEntityTypes(stack);
        if (entities.size() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_entity"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_entity.list"));
            entities.forEach(e -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.list_item", new Object[]{e.func_212546_e()})));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            if (!world.func_201670_d()) {
                EntityModuleContainerProvider containerProvider = new EntityModuleContainerProvider(player, hand);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, buffer -> buffer.func_179249_a((Enum)hand));
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (ItemScannerModuleEntityConfigurable.addEntityType(player.func_184586_b(hand), target.func_200600_R())) {
            player.func_184609_a(hand);
            player.field_71071_by.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        if (player.func_130014_f_().field_72995_K && !ItemScannerModuleEntityConfigurable.isLocked(stack)) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.no_free_slots"), Constants.CHAT_LINE_ID);
        }
        return ActionResultType.SUCCESS;
    }
}

