/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.config;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import li.cil.scannable.common.Scannable;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Util;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Settings {
    private static final ServerSettings SERVER_INSTANCE;
    private static final ForgeConfigSpec SERVER_SPEC;
    public static boolean useEnergy;
    public static int energyCapacityScanner;
    public static int energyCostModuleRange;
    public static int energyCostModuleAnimal;
    public static int energyCostModuleMonster;
    public static int energyCostModuleOreCommon;
    public static int energyCostModuleOreRare;
    public static int energyCostModuleBlock;
    public static int energyCostModuleStructure;
    public static int energyCostModuleFluid;
    public static int energyCostModuleEntity;
    public static int baseScanRadius;
    public static int scanStayDuration;
    public static Set<ResourceLocation> ignoredBlocks;
    public static Set<ResourceLocation> ignoredBlockTags;
    public static Set<ResourceLocation> commonOreBlocks;
    public static Set<ResourceLocation> commonOreBlockTags;
    public static Set<ResourceLocation> rareOreBlocks;
    public static Set<ResourceLocation> rareOreBlockTags;
    public static Set<ResourceLocation> ignoredFluidTags;
    public static Set<String> structures;
    private static final ClientSettings CLIENT_INSTANCE;
    private static final ForgeConfigSpec CLIENT_SPEC;
    public static Object2IntMap<ResourceLocation> blockColors;
    public static Object2IntMap<ResourceLocation> blockTagColors;
    public static Object2IntMap<ResourceLocation> fluidColors;
    public static Object2IntMap<ResourceLocation> fluidTagColors;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }

    public static boolean isServerConfig(ForgeConfigSpec spec) {
        return spec == SERVER_SPEC;
    }

    public static boolean isClientConfig(ForgeConfigSpec spec) {
        return spec == CLIENT_SPEC;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (Settings.isServerConfig(configEvent.getConfig().getSpec())) {
            useEnergy = (Boolean)Settings.SERVER_INSTANCE.useEnergy.get();
            energyCapacityScanner = (Integer)Settings.SERVER_INSTANCE.energyCapacityScanner.get();
            energyCostModuleRange = (Integer)Settings.SERVER_INSTANCE.energyCostModuleRange.get();
            energyCostModuleAnimal = (Integer)Settings.SERVER_INSTANCE.energyCostModuleAnimal.get();
            energyCostModuleMonster = (Integer)Settings.SERVER_INSTANCE.energyCostModuleMonster.get();
            energyCostModuleOreCommon = (Integer)Settings.SERVER_INSTANCE.energyCostModuleOreCommon.get();
            energyCostModuleOreRare = (Integer)Settings.SERVER_INSTANCE.energyCostModuleOreRare.get();
            energyCostModuleBlock = (Integer)Settings.SERVER_INSTANCE.energyCostModuleBlock.get();
            energyCostModuleStructure = (Integer)Settings.SERVER_INSTANCE.energyCostModuleStructure.get();
            energyCostModuleFluid = (Integer)Settings.SERVER_INSTANCE.energyCostModuleFluid.get();
            energyCostModuleEntity = (Integer)Settings.SERVER_INSTANCE.energyCostModuleEntity.get();
            baseScanRadius = (Integer)Settings.SERVER_INSTANCE.baseScanRadius.get();
            scanStayDuration = (Integer)Settings.SERVER_INSTANCE.scanStayDuration.get();
            ignoredBlocks = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.ignoredBlocks.get(), ResourceLocation::new);
            ignoredBlockTags = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.ignoredBlockTags.get(), ResourceLocation::new);
            commonOreBlocks = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.commonOreBlocks.get(), ResourceLocation::new);
            commonOreBlockTags = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.commonOreBlockTags.get(), ResourceLocation::new);
            rareOreBlocks = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.rareOreBlocks.get(), ResourceLocation::new);
            rareOreBlockTags = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.rareOreBlockTags.get(), ResourceLocation::new);
            ignoredFluidTags = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.ignoredFluidTags.get(), ResourceLocation::new);
            structures = Settings.deserializeSet((List)Settings.SERVER_INSTANCE.structures.get(), s -> s);
        }
        if (Settings.isClientConfig(configEvent.getConfig().getSpec())) {
            Settings.deserializeMap(blockColors, (List)Settings.CLIENT_INSTANCE.blockColors.get(), ResourceLocation::new, Integer::decode);
            Settings.deserializeMap(blockTagColors, (List)Settings.CLIENT_INSTANCE.blockTagColors.get(), ResourceLocation::new, Integer::decode);
            Settings.deserializeMap(fluidColors, (List)Settings.CLIENT_INSTANCE.fluidColors.get(), ResourceLocation::new, Integer::decode);
            Settings.deserializeMap(fluidTagColors, (List)Settings.CLIENT_INSTANCE.fluidTagColors.get(), ResourceLocation::new, Integer::decode);
        }
    }

    private static boolean validateResourceLocationMapEntry(Object value) {
        return Settings.validateMapEntry(value, Settings::validateResourceLocation);
    }

    private static boolean validateMapEntry(Object value, Predicate<String> validateKey) {
        String[] keyValue = ((String)value).split("=", 2);
        if (keyValue.length != 2) {
            return false;
        }
        if (!validateKey.test(keyValue[0])) {
            return false;
        }
        try {
            Integer.decode(keyValue[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean validateResourceLocation(Object value) {
        try {
            new ResourceLocation((String)value);
            return true;
        }
        catch (ResourceLocationException e) {
            Scannable.getLog().error((Object)e);
            return false;
        }
    }

    private static <T> List<? extends String> serializeSet(Set<T> set, Function<T, String> serializer) {
        ArrayList<String> result = new ArrayList<String>();
        for (T v : set) {
            String serialized = serializer.apply(v);
            if (serialized == null) continue;
            result.add(serialized);
        }
        return result;
    }

    private static <T> Set<T> deserializeSet(List<? extends String> list, Function<String, T> deserializer) {
        HashSet<String> result = new HashSet<String>();
        for (String string : list) {
            String t = deserializer.apply(string);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    private static <K, V> List<? extends String> serializeMap(Map<K, V> map, Function<K, String> keySerializer, Function<V, String> valueSerializer) {
        ArrayList result = new ArrayList();
        map.forEach((k, v) -> {
            String serializedKey = (String)keySerializer.apply(k);
            String serializedValue = (String)valueSerializer.apply(v);
            if (serializedKey != null && serializedValue != null) {
                result.add(serializedKey + "=" + serializedValue);
            }
        });
        return result;
    }

    private static <K, V> void deserializeMap(Map<K, V> map, List<? extends String> list, Function<String, K> keyDeserializer, Function<String, V> valueDeserializer) {
        map.clear();
        for (String string : list) {
            String[] keyValue = string.split("=", 2);
            if (keyValue.length != 2) {
                Scannable.getLog().error("Failed parsing setting value [{}].", (Object)string);
                continue;
            }
            K key = keyDeserializer.apply(keyValue[0]);
            V value = valueDeserializer.apply(keyValue[1]);
            if (key == null || value == null) continue;
            map.put(key, value);
        }
    }

    private Settings() {
    }

    static {
        useEnergy = true;
        energyCapacityScanner = 5000;
        energyCostModuleRange = 100;
        energyCostModuleAnimal = 25;
        energyCostModuleMonster = 50;
        energyCostModuleOreCommon = 75;
        energyCostModuleOreRare = 100;
        energyCostModuleBlock = 100;
        energyCostModuleStructure = 150;
        energyCostModuleFluid = 50;
        energyCostModuleEntity = 75;
        baseScanRadius = 64;
        scanStayDuration = 10000;
        ignoredBlocks = (Set)Util.func_200696_a(new HashSet(), c -> c.add(Blocks.field_150483_bI.getRegistryName()));
        ignoredBlockTags = new HashSet<ResourceLocation>();
        commonOreBlocks = (Set)Util.func_200696_a(new HashSet(), c -> c.add(Blocks.field_150435_aG.getRegistryName()));
        commonOreBlockTags = (Set)Util.func_200696_a(new HashSet(), c -> {
            c.add(Tags.Blocks.ORES_COAL.func_230234_a_());
            c.add(Tags.Blocks.ORES_IRON.func_230234_a_());
            c.add(Tags.Blocks.ORES_REDSTONE.func_230234_a_());
            c.add(Tags.Blocks.ORES_QUARTZ.func_230234_a_());
            c.add(new ResourceLocation("forge", "ores/copper"));
            c.add(new ResourceLocation("forge", "ores/tin"));
        });
        rareOreBlocks = (Set)Util.func_200696_a(new HashSet(), c -> c.add(Blocks.field_150426_aN.getRegistryName()));
        rareOreBlockTags = new HashSet<ResourceLocation>();
        ignoredFluidTags = new HashSet<ResourceLocation>();
        structures = (Set)Util.func_200696_a(new HashSet(), c -> c.addAll(GameData.getStructureMap().keySet()));
        blockColors = new Object2IntOpenHashMap();
        blockTagColors = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenHashMap(), c -> {
            c.put((Object)Tags.Blocks.ORES_COAL.func_230234_a_(), MaterialColor.field_151670_w.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_IRON.func_230234_a_(), MaterialColor.field_151650_B.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_GOLD.func_230234_a_(), MaterialColor.field_151647_F.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_LAPIS.func_230234_a_(), MaterialColor.field_151652_H.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_DIAMOND.func_230234_a_(), MaterialColor.field_151648_G.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_REDSTONE.func_230234_a_(), MaterialColor.field_151645_D.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_EMERALD.func_230234_a_(), MaterialColor.field_151653_I.field_76291_p);
            c.put((Object)Tags.Blocks.ORES_QUARTZ.func_230234_a_(), MaterialColor.field_151677_p.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/tin"), MaterialColor.field_151679_y.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/copper"), MaterialColor.field_193562_N.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/lead"), MaterialColor.field_193572_X.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/silver"), MaterialColor.field_197656_x.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/nickel"), MaterialColor.field_151674_s.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/platinum"), MaterialColor.field_193561_M.field_76291_p);
            c.put((Object)new ResourceLocation("forge", "ores/mithril"), MaterialColor.field_151678_z.field_76291_p);
        });
        fluidColors = new Object2IntOpenHashMap();
        fluidTagColors = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenHashMap(), c -> {
            c.put((Object)FluidTags.field_206959_a.func_230234_a_(), MaterialColor.field_151662_n.field_76291_p);
            c.put((Object)FluidTags.field_206960_b.func_230234_a_(), MaterialColor.field_193562_N.field_76291_p);
        });
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ServerSettings::new);
        SERVER_INSTANCE = (ServerSettings)serverConfig.getKey();
        SERVER_SPEC = (ForgeConfigSpec)serverConfig.getValue();
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ClientSettings::new);
        CLIENT_INSTANCE = (ClientSettings)clientConfig.getKey();
        CLIENT_SPEC = (ForgeConfigSpec)clientConfig.getValue();
    }

    private static final class ClientSettings {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blockColors;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> blockTagColors;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> fluidColors;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> fluidTagColors;

        public ClientSettings(ForgeConfigSpec.Builder builder) {
            this.blockColors = builder.translation("config.scannable.blockColors").comment("The colors for blocks used when rendering their result bounding box\nby block name. Each entry must be a key-value pair separated by a `=`,\nwith the key being the tag name and the value being the hexadecimal\nRGB value of the color.").worldRestart().defineList("blockColors", Settings.serializeMap(blockColors, ResourceLocation::toString, c -> "0x" + Integer.toHexString(c)), x$0 -> Settings.validateResourceLocationMapEntry(x$0));
            this.blockTagColors = builder.translation("config.scannable.blockTagColors").comment("The colors for blocks used when rendering their result bounding box\nby block tag. See `blockColors` for format entries have to be in.").worldRestart().defineList("blockTagColors", Settings.serializeMap(blockTagColors, ResourceLocation::toString, c -> "0x" + Integer.toHexString(c)), x$0 -> Settings.validateResourceLocationMapEntry(x$0));
            this.fluidColors = builder.translation("config.scannable.fluidColors").comment("The colors for fluids used when rendering their result bounding box\nby fluid name. See `blockColors` for format entries have to be in.").worldRestart().defineList("fluidColors", Settings.serializeMap(fluidColors, ResourceLocation::toString, c -> "0x" + Integer.toHexString(c)), x$0 -> Settings.validateResourceLocationMapEntry(x$0));
            this.fluidTagColors = builder.translation("config.scannable.fluidTagColors").comment("The colors for fluids used when rendering their result bounding box\nby fluid tag. See `blockColors` for format entries have to be in.").worldRestart().defineList("fluidTagColors", Settings.serializeMap(fluidTagColors, ResourceLocation::toString, c -> "0x" + Integer.toHexString(c)), x$0 -> Settings.validateResourceLocationMapEntry(x$0));
        }
    }

    private static final class ServerSettings {
        public ForgeConfigSpec.BooleanValue useEnergy;
        public ForgeConfigSpec.IntValue energyCapacityScanner;
        public ForgeConfigSpec.IntValue energyCostModuleRange;
        public ForgeConfigSpec.IntValue energyCostModuleAnimal;
        public ForgeConfigSpec.IntValue energyCostModuleMonster;
        public ForgeConfigSpec.IntValue energyCostModuleOreCommon;
        public ForgeConfigSpec.IntValue energyCostModuleOreRare;
        public ForgeConfigSpec.IntValue energyCostModuleBlock;
        public ForgeConfigSpec.IntValue energyCostModuleStructure;
        public ForgeConfigSpec.IntValue energyCostModuleFluid;
        public ForgeConfigSpec.IntValue energyCostModuleEntity;
        public ForgeConfigSpec.IntValue baseScanRadius;
        public ForgeConfigSpec.IntValue scanStayDuration;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> ignoredBlocks;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> ignoredBlockTags;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> commonOreBlocks;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> commonOreBlockTags;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> rareOreBlocks;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> rareOreBlockTags;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> ignoredFluidTags;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> structures;

        public ServerSettings(ForgeConfigSpec.Builder builder) {
            builder.push("energy");
            this.useEnergy = builder.translation("config.scannable.useEnergy").comment("Whether to consume energy when performing a scan. Will make the scanner a chargeable item.").worldRestart().define("useEnergy", useEnergy);
            this.energyCapacityScanner = builder.translation("config.scannable.energyCapacityScanner").comment("Amount of energy that can be stored in a scanner.").worldRestart().defineInRange("energyCapacityScanner", energyCapacityScanner, 0, Integer.MAX_VALUE);
            this.energyCostModuleRange = builder.translation("config.scannable.energyCostModuleRange").comment("Amount of energy used by the range module per scan.").worldRestart().defineInRange("energyCostModuleRange", energyCostModuleRange, 0, Integer.MAX_VALUE);
            this.energyCostModuleAnimal = builder.translation("config.scannable.energyCostModuleAnimal").comment("Amount of energy used by the animal module per scan.").worldRestart().defineInRange("energyCostModuleAnimal", energyCostModuleAnimal, 0, Integer.MAX_VALUE);
            this.energyCostModuleMonster = builder.translation("config.scannable.energyCostModuleMonster").comment("Amount of energy used by the monster module per scan.").worldRestart().defineInRange("energyCostModuleMonster", energyCostModuleMonster, 0, Integer.MAX_VALUE);
            this.energyCostModuleOreCommon = builder.translation("config.scannable.energyCostModuleOreCommon").comment("Amount of energy used by the common ore module per scan.").worldRestart().defineInRange("energyCostModuleOreCommon", energyCostModuleOreCommon, 0, Integer.MAX_VALUE);
            this.energyCostModuleOreRare = builder.translation("config.scannable.energyCostModuleOreRare").comment("Amount of energy used by the rare ore module per scan.").worldRestart().defineInRange("energyCostModuleOreRare", energyCostModuleOreRare, 0, Integer.MAX_VALUE);
            this.energyCostModuleBlock = builder.translation("config.scannable.energyCostModuleBlock").comment("Amount of energy used by the block module per scan.").worldRestart().defineInRange("energyCostModuleBlock", energyCostModuleBlock, 0, Integer.MAX_VALUE);
            this.energyCostModuleStructure = builder.translation("config.scannable.energyCostModuleStructure").comment("Amount of energy used by the structure module per scan.").worldRestart().defineInRange("energyCostModuleStructure", energyCostModuleStructure, 0, Integer.MAX_VALUE);
            this.energyCostModuleFluid = builder.translation("config.scannable.energyCostModuleFluid").comment("Amount of energy used by the fluid module per scan.").worldRestart().defineInRange("energyCostModuleFluid", energyCostModuleFluid, 0, Integer.MAX_VALUE);
            this.energyCostModuleEntity = builder.translation("config.scannable.energyCostModuleEntity").comment("Amount of energy used by the entity module per scan.").worldRestart().defineInRange("energyCostModuleEntity", energyCostModuleEntity, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("general");
            this.baseScanRadius = builder.translation("config.scannable.baseScanRadius").comment("The basic scan radius without range modules. Higher values mean more computational\noverhead and thus potentially worse performance while scanning.\nIMPORTANT: some modules such as the block and ore scanner modules will already use\na reduced radius based on this value. Specifically, the ore scanners multiply this\nvalue by 0.25, and the block scanner multiplies it by 0.5.\nRange modules will boost the range by half this value.").worldRestart().defineInRange("baseScanRadius", baseScanRadius, 16, 128);
            this.scanStayDuration = builder.translation("config.scannable.scanStayDuration").comment("How long the results from a scan should remain visible, in milliseconds.").worldRestart().defineInRange("scanStayDuration", scanStayDuration, 1000, 300000);
            builder.pop();
            builder.push("blocks");
            this.ignoredBlocks = builder.translation("config.scannable.ignoredBlocks").comment("Registry names of blocks that should be ignored.\nBlocks in this list will be excluded from the default ore list based on the forge:ores\ntag and it will be impossible to tune the entity module to this block.").worldRestart().defineList("ignoredBlocks", Settings.serializeSet(ignoredBlocks, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            this.ignoredBlockTags = builder.translation("config.scannable.ignoredBlockTags").comment("Tag names of block tags that should be ignored.\nBlocks matching a tag in this list will be excluded from the default ore list based on theforge:ores tag and it will be impossible to tune the entity module to this block.").worldRestart().defineList("ignoredBlockTags", Settings.serializeSet(ignoredBlockTags, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            builder.pop();
            builder.push("ores");
            this.commonOreBlocks = builder.translation("config.scannable.oreCommonBlocks").comment("Registry names of blocks considered 'common ores', requiring the common ore scanner module.").worldRestart().defineList("commonOreBlocks", Settings.serializeSet(commonOreBlocks, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            this.commonOreBlockTags = builder.translation("config.scannable.oreCommonBlockTags").comment("Block tags of blocks considered 'common ores', requiring the common ore scanner module.").worldRestart().defineList("commonOreBlockTags", Settings.serializeSet(commonOreBlockTags, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            this.rareOreBlocks = builder.translation("config.scannable.oreRareBlocks").comment("Registry names of blocks considered 'rare ores', requiring the common ore scanner module.").worldRestart().defineList("rareOreBlocks", Settings.serializeSet(rareOreBlocks, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            this.rareOreBlockTags = builder.translation("config.scannable.oreRareBlockTags").comment("Block tags of blocks considered 'rare ores', requiring the common ore scanner module.\nAny block with the forge:ores tag is implicitly in this list, unless the block also\nmatches an ignored or common ore block tag, or is an ignored or common block.").worldRestart().defineList("rareOreBlockTags", Settings.serializeSet(rareOreBlockTags, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            builder.pop();
            builder.push("fluids");
            this.ignoredFluidTags = builder.translation("config.scannable.ignoredFluidTags").comment("Fluid tags of fluids that should be ignored.").worldRestart().defineList("ignoredFluidTags", Settings.serializeSet(ignoredFluidTags, ResourceLocation::toString), x$0 -> Settings.validateResourceLocation(x$0));
            builder.pop();
            builder.push("structures");
            this.structures = builder.translation("config.scannable.structures").comment("The list of structures the structure module scans for.").worldRestart().defineList("structures", Settings.serializeSet(structures, v -> v), o -> GameData.getStructureMap().containsKey(o));
            builder.pop();
        }
    }
}

