/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.energy.EnergyStorageScanner;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public final class CapabilityProviderScanner
implements ICapabilityProvider {
    private final ItemHandlerScanner itemHandler;
    private final EnergyStorageScanner energyStorage;

    public CapabilityProviderScanner(ItemStack container) {
        this.itemHandler = new ItemHandlerScanner(container);
        this.energyStorage = new EnergyStorageScanner(container);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> {
                this.itemHandler.updateFromNBT();
                return this.itemHandler;
            });
        }
        if (Settings.useEnergy && capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> {
                this.energyStorage.updateFromNBT();
                return this.energyStorage;
            });
        }
        return LazyOptional.empty();
    }
}

