/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.scannable.client.gui.AbstractConfigurableModuleScreen;
import li.cil.scannable.common.container.EntityModuleContainer;
import li.cil.scannable.common.item.ItemScannerModuleEntityConfigurable;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageSetConfiguredModuleItemAt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;

public class EntityModuleScreen
extends AbstractConfigurableModuleScreen<EntityModuleContainer, EntityType<?>> {
    private static final Map<EntityType<?>, Entity> RENDER_ENTITIES = new HashMap();

    public EntityModuleScreen(EntityModuleContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title, "gui.scannable.module_entity.list");
    }

    @Override
    protected List<EntityType<?>> getConfiguredItems(ItemStack stack) {
        return ItemScannerModuleEntityConfigurable.getEntityTypes(stack);
    }

    @Override
    protected ITextComponent getItemName(EntityType<?> entityType) {
        return entityType.func_212546_e();
    }

    @Override
    protected void renderConfiguredItem(EntityType<?> entityType, int x, int y) {
        this.renderEntity(x + 8, y + 13, entityType);
    }

    @Override
    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
        ResourceLocation registryName;
        EntityType entityType;
        if (value.func_77973_b() instanceof SpawnEggItem && (entityType = ((SpawnEggItem)value.func_77973_b()).func_208076_b(value.func_77978_p())) != null && (registryName = entityType.getRegistryName()) != null) {
            Network.INSTANCE.sendToServer((Object)new MessageSetConfiguredModuleItemAt(((EntityModuleContainer)this.field_147002_h).field_75152_c, slot, registryName.toString()));
        }
    }

    private void renderEntity(int x, int y, EntityType<?> entityType) {
        Entity entity = this.getRenderEntity(entityType);
        if (entity == null) {
            return;
        }
        entity.func_70029_a(this.field_213127_e.field_70458_d.func_130014_f_());
        EntitySize bounds = entityType.func_220334_j();
        float size = Math.max(bounds.field_220315_a, bounds.field_220316_b);
        float scale = 11.0f / size;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        quaternion.func_195890_a(Vector3f.field_229178_a_.func_229187_a_(20.0f));
        quaternion.func_195890_a(Vector3f.field_229181_d_.func_229187_a_(150.0f));
        matrixStack.func_227863_a_(quaternion);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        quaternion.func_195892_e();
        renderManager.func_229089_a_(quaternion);
        renderManager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        renderManager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0);
        buffer.func_228461_a_();
        renderManager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    @Nullable
    private Entity getRenderEntity(EntityType<?> entityType) {
        return RENDER_ENTITIES.computeIfAbsent(entityType, t -> t.func_200721_a(this.field_213127_e.field_70458_d.func_130014_f_()));
    }
}

