/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.container.AbstractModuleContainer;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageRemoveConfiguredModuleItemAt;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractConfigurableModuleScreen<TContainer extends AbstractModuleContainer, TItem>
extends ContainerScreen<TContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("scannable", "textures/gui/container/module_configurable.png");
    public static final int SLOTS_ORIGIN_X = 62;
    public static final int SLOTS_ORIGIN_Y = 20;
    public static final int SLOT_SIZE = 18;
    private final String listCaptionTranslationKey;

    public AbstractConfigurableModuleScreen(TContainer container, PlayerInventory inventory, ITextComponent title, String listCaptionTranslationKey) {
        super(container, inventory, title);
        this.field_147000_g = 133;
        this.field_230711_n_ = false;
        this.listCaptionTranslationKey = listCaptionTranslationKey;
        this.field_238744_r_ = 8;
        this.field_238745_s_ = 39;
    }

    private ItemStack getHeldItem() {
        return this.field_213127_e.field_70458_d.func_184586_b(((AbstractModuleContainer)this.field_147002_h).getHand());
    }

    protected abstract List<TItem> getConfiguredItems(ItemStack var1);

    protected abstract ITextComponent getItemName(TItem var1);

    protected abstract void renderConfiguredItem(TItem var1, int var2, int var3);

    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < Math.min(items.size(), 5); ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.func_195359_a(x, 20, 18, 18, mouseX, mouseY)) continue;
            TItem item = items.get(slot);
            this.func_238652_a_(matrixStack, this.getItemName(item), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)this.listCaptionTranslationKey, (Object[])new Object[0]), 8.0f, 23.0f, 0x404040);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (this.func_195359_a(x, 20, 18, 18, mouseX, mouseY)) {
                this.drawHoverHighlight(matrixStack, x, 20, 16, 16);
            }
            if (slot >= items.size()) continue;
            TItem item = items.get(slot);
            this.renderConfiguredItem(item, x, 20);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.func_195359_a(x, 20, 18, 18, mouseX, mouseY)) continue;
            ItemStack heldItemStack = this.field_213127_e.func_70445_o();
            if (!heldItemStack.func_190926_b()) {
                this.configureItemAt(this.getHeldItem(), slot, heldItemStack);
            } else {
                Network.INSTANCE.sendToServer((Object)new MessageRemoveConfiguredModuleItemAt(((AbstractModuleContainer)this.field_147002_h).field_75152_c, slot));
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void func_184098_a(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            ItemStack heldItem = this.getHeldItem();
            if (slot.func_75211_c() == heldItem) {
                return;
            }
            if (type == ClickType.SWAP && this.field_213127_e.func_70301_a(mouseButton) == heldItem) {
                return;
            }
        }
        super.func_184098_a(slot, slotId, mouseButton, type);
    }

    private void drawHoverHighlight(MatrixStack matrixStack, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_238468_a_(matrixStack, x, y, x + width, y + height, this.slotColor, this.slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }
}

