/*
 * Decompiled with CFR 0.152.
 */
package com.github.salvadormg15.rubber_duck;

import com.github.salvadormg15.rubber_duck.Registries;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class RubberDuckBlock
extends RedstoneDiodeBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    public static final BooleanProperty UNLOCK = BooleanProperty.func_177716_a((String)"unlock");
    VoxelShape field_196347_b = Stream.of(Block.func_208617_a((double)4.6, (double)0.0, (double)5.0, (double)11.4, (double)5.0, (double)11.0), Block.func_208617_a((double)6.0, (double)4.0, (double)3.0, (double)10.0, (double)8.0, (double)7.0), Block.func_208617_a((double)6.4, (double)4.0, (double)1.4, (double)9.6, (double)5.0, (double)3.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();
    private static double onEntitySpawnChance = 0.04;

    public RubberDuckBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_215713_z).func_200948_a(0.2f, 0.2f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_196348_c, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UNLOCK, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
        this.runCalculations(this.field_196347_b);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196348_c, TRIGGERED, UNLOCK, field_185512_D});
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        this.press(p_225533_1_, p_225533_2_, p_225533_3_);
        p_225533_2_.func_184133_a(p_225533_4_, p_225533_3_, (SoundEvent)Registries.RUBBER_DUCK_USE.get(), SoundCategory.BLOCKS, 1.3f, 1.0f);
        return ActionResultType.func_233537_a_((boolean)p_225533_2_.field_72995_K);
    }

    public void press(BlockState p_226910_1_, World p_226910_2_, BlockPos p_226910_3_) {
        p_226910_2_.func_180501_a(p_226910_3_, (BlockState)((BlockState)p_226910_1_.func_206870_a((Property)field_196348_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(p_226910_2_, p_226910_3_, p_226910_1_);
        p_226910_2_.func_205220_G_().func_205360_a(p_226910_3_, (Object)this, 0);
    }

    protected void updateNeighbors(World p_176400_1_, BlockPos p_176400_2_, BlockState p_176400_3_) {
        for (Direction direction : Direction.values()) {
            if (ForgeEventFactory.onNeighborNotify((World)p_176400_1_, (BlockPos)p_176400_2_, (BlockState)p_176400_1_.func_180495_p(p_176400_2_), EnumSet.of(direction), (boolean)false).isCanceled()) {
                return;
            }
            BlockPos blockpos = p_176400_2_.func_177972_a(direction);
            p_176400_1_.func_190524_a(blockpos, (Block)this, p_176400_2_);
            p_176400_1_.func_175695_a(blockpos, (Block)this, direction.func_176734_d());
        }
    }

    protected void func_176400_h(World p_176400_1_, BlockPos p_176400_2_, BlockState p_176400_3_) {
        this.updateNeighbors(p_176400_1_, p_176400_2_, p_176400_3_);
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!this.func_176405_b((IWorldReader)p_225534_2_, p_225534_3_, p_225534_1_) || ((Boolean)p_225534_1_.func_177229_b((Property)UNLOCK)).booleanValue()) {
            boolean unlocked = (Boolean)p_225534_1_.func_177229_b((Property)UNLOCK);
            boolean powered = (Boolean)p_225534_1_.func_177229_b((Property)field_196348_c);
            boolean triggered = (Boolean)p_225534_1_.func_177229_b((Property)TRIGGERED);
            boolean setPowered = false;
            boolean setNewState = false;
            boolean setScheduleTick = false;
            TickPriority tickPriority = TickPriority.NORMAL;
            boolean playSound = false;
            int delay = this.func_196346_i(p_225534_1_);
            BlockState newState = p_225534_1_;
            if (unlocked) {
                setNewState = true;
                newState = (BlockState)newState.func_206870_a((Property)UNLOCK, (Comparable)Boolean.valueOf(false));
            }
            if (powered) {
                boolean flag;
                List list = p_225534_2_.func_217357_a(AbstractArrowEntity.class, p_225534_1_.func_196954_c((IBlockReader)p_225534_2_, p_225534_3_).func_197752_a().func_186670_a(p_225534_3_));
                boolean bl = flag = !list.isEmpty();
                if (flag != powered) {
                    setPowered = true;
                    setNewState = true;
                    newState = (BlockState)newState.func_206870_a((Property)field_196348_c, (Comparable)Boolean.valueOf(flag));
                }
                if (flag) {
                    setScheduleTick = true;
                    delay = this.getPressDuration();
                }
            }
            boolean flag1 = this.func_176404_e((World)p_225534_2_, p_225534_3_, p_225534_1_);
            if (!setPowered) {
                if (!powered) {
                    if (triggered && !flag1) {
                        setNewState = true;
                        newState = (BlockState)newState.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false));
                    } else if (!triggered) {
                        playSound = true;
                        setNewState = true;
                        newState = (BlockState)newState.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true));
                        if (!flag1) {
                            setScheduleTick = true;
                            tickPriority = TickPriority.VERY_HIGH;
                        }
                    }
                }
            } else {
                setScheduleTick = true;
            }
            if (playSound) {
                p_225534_2_.func_184133_a(null, p_225534_3_, (SoundEvent)Registries.RUBBER_DUCK_USE.get(), SoundCategory.BLOCKS, 1.3f, 1.0f);
            }
            if (setNewState) {
                p_225534_2_.func_180501_a(p_225534_3_, newState, setPowered ? 3 : 2);
            }
            if (setScheduleTick) {
                p_225534_2_.func_205220_G_().func_205362_a(new BlockPos((Vector3i)p_225534_3_), (Object)this, delay, tickPriority);
            }
        } else {
            p_225534_2_.func_180501_a(p_225534_3_, (BlockState)p_225534_1_.func_206870_a((Property)UNLOCK, (Comparable)Boolean.valueOf(true)), 2);
            p_225534_2_.func_205220_G_().func_205360_a(new BlockPos((Vector3i)p_225534_3_), (Object)this, this.getPressDuration());
        }
    }

    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        if (!p_196262_2_.field_72995_K && !((Boolean)p_196262_1_.func_177229_b((Property)field_196348_c)).booleanValue()) {
            this.checkPressed(p_196262_1_, p_196262_2_, p_196262_3_);
        }
    }

    private void checkPressed(BlockState p_185616_1_, World p_185616_2_, BlockPos p_185616_3_) {
        List list = p_185616_2_.func_217357_a(AbstractArrowEntity.class, p_185616_1_.func_196954_c((IBlockReader)p_185616_2_, p_185616_3_).func_197752_a().func_186670_a(p_185616_3_));
        boolean flag = !list.isEmpty();
        boolean flag1 = (Boolean)p_185616_1_.func_177229_b((Property)field_196348_c);
        BlockState newState = p_185616_1_;
        if (flag != flag1) {
            if (flag) {
                p_185616_2_.func_184133_a(null, p_185616_3_, (SoundEvent)Registries.RUBBER_DUCK_USE.get(), SoundCategory.BLOCKS, 1.3f, 1.0f);
                newState = (BlockState)newState.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true));
            }
            newState = (BlockState)newState.func_206870_a((Property)field_196348_c, (Comparable)Boolean.valueOf(flag));
            p_185616_2_.func_180501_a(p_185616_3_, newState, 3);
        }
        if (flag) {
            p_185616_2_.func_205220_G_().func_205360_a(new BlockPos((Vector3i)p_185616_3_), (Object)this, this.getPressDuration());
        }
    }

    private int getPressDuration() {
        return 20;
    }

    public boolean func_176405_b(IWorldReader p_176405_1_, BlockPos p_176405_2_, BlockState p_176405_3_) {
        return (Boolean)p_176405_3_.func_177229_b((Property)field_196348_c);
    }

    protected void func_176398_g(World p_176398_1_, BlockPos p_176398_2_, BlockState p_176398_3_) {
        boolean flag1;
        boolean flag;
        if (!this.func_176405_b((IWorldReader)p_176398_1_, p_176398_2_, p_176398_3_) && (flag = ((Boolean)p_176398_3_.func_177229_b((Property)TRIGGERED)).booleanValue()) != (flag1 = this.func_176404_e(p_176398_1_, p_176398_2_, p_176398_3_)) && !p_176398_1_.func_205220_G_().func_205361_b(p_176398_2_, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.func_176402_i((IBlockReader)p_176398_1_, p_176398_2_, p_176398_3_)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            p_176398_1_.func_205220_G_().func_205362_a(p_176398_2_, (Object)this, this.func_196346_i(p_176398_3_), tickpriority);
        }
    }

    protected boolean func_176404_e(World p_176404_1_, BlockPos p_176404_2_, BlockState p_176404_3_) {
        return p_176404_1_.func_175640_z(p_176404_2_);
    }

    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return (Boolean)p_176211_1_.func_177229_b((Property)field_196348_c) != false && Direction.UP == p_176211_4_ ? 15 : 0;
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return (Boolean)p_180656_1_.func_177229_b((Property)field_196348_c) != false ? 15 : 0;
    }

    protected int func_196346_i(BlockState p_196346_1_) {
        return 2;
    }

    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (p_220082_4_.func_203425_a(Blocks.field_150350_a)) {
            p_220082_2_.func_184133_a(null, p_220082_3_, (SoundEvent)Registries.RUBBER_DUCK_PLACE.get(), SoundCategory.BLOCKS, 0.8f, 1.0f);
        }
        super.func_220082_b(p_220082_1_, p_220082_2_, p_220082_3_, p_220082_4_, p_220082_5_);
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (p_196243_4_.func_203425_a(Blocks.field_150350_a)) {
            p_196243_2_.func_184133_a(null, p_196243_3_, (SoundEvent)Registries.RUBBER_DUCK_PLACE.get(), SoundCategory.BLOCKS, 0.8f, 1.2f);
        }
        super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
    }

    protected void runCalculations(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            RubberDuckBlock.calculateShapes(direction, shape);
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        VoxelShape voxel = SHAPES.get(p_220053_1_.func_177229_b((Property)field_185512_D));
        return voxel != null ? voxel : VoxelShapes.func_197868_b();
    }

    protected static void calculateShapes(Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, VoxelShapes.func_197880_a()};
        int times = (to.func_176736_b() - Direction.NORTH.func_176736_b() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].func_197755_b((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = VoxelShapes.func_197872_a((VoxelShape)buffer[1], (VoxelShape)VoxelShapes.func_197873_a((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = VoxelShapes.func_197880_a();
        }
        SHAPES.put(to, buffer[0]);
    }

    public static double getOnEntitySpawnChance() {
        return onEntitySpawnChance;
    }
}

