/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.rei.impl.common.InternalLogger;

public final class ThreadCreator {
    private final ThreadGroup group;
    private final AtomicInteger threadId = new AtomicInteger(0);

    public ThreadCreator(String groupName) {
        this.group = new ThreadGroup(groupName);
    }

    public ThreadGroup group() {
        return this.group;
    }

    public AtomicInteger threadId() {
        return this.threadId;
    }

    public ExecutorService asService() {
        return this.asService(Runtime.getRuntime().availableProcessors());
    }

    public ExecutorService asService(int poolSize) {
        return new ForkJoinPool(poolSize, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName(this.group().getName() + "-" + this.threadId().getAndIncrement());
            worker.setContextClassLoader(this.getClass().getClassLoader());
            return worker;
        }, ($, exception) -> {
            if (!(exception instanceof InterruptedException || exception instanceof CancellationException || exception instanceof ThreadDeath)) {
                InternalLogger.getInstance().throwException(exception);
            }
        }, true);
    }
}

