/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.fabric;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.init.PluginDetector;
import me.shedaniel.rei.impl.init.PrimitivePlatformAdapter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import org.apache.commons.lang3.tuple.Pair;

public class PluginDetectorImpl
implements PluginDetector {
    private static <P extends REIPlugin<?>> void loadPlugin(Class<? extends P> pluginClass, Consumer<? super REIPluginProvider<P>> consumer) {
        LinkedHashMap<String, Env> entrypoints = new LinkedHashMap<String, Env>();
        entrypoints.put("rei_server", Env.SERVER);
        entrypoints.put("rei_common", null);
        entrypoints.put("rei", null);
        entrypoints.put("rei_client", Env.CLIENT);
        LinkedHashSet<String> deprecatedEntrypoints = new LinkedHashSet<String>(Arrays.asList("rei_containers", "rei_plugins", "rei_plugins_v0", "rei"));
        List containers = Stream.concat(entrypoints.entrySet().stream().filter(entry -> entry.getValue() == null || Platform.getEnvironment() == entry.getValue()).map(Map.Entry::getKey), deprecatedEntrypoints.stream()).distinct().flatMap(name -> FabricLoader.getInstance().getEntrypointContainers(name, REIPluginProvider.class).stream().map(container -> Pair.of((Object)container, (Object)name))).collect(Collectors.toList());
        block2: for (Pair pair : containers) {
            final EntrypointContainer container = (EntrypointContainer)pair.getLeft();
            String name2 = (String)pair.getRight();
            try {
                REIPluginProvider plugin;
                if (deprecatedEntrypoints.contains(name2)) {
                    RoughlyEnoughItemsState.warn("The entrypoint used by %s, \"%s\" is deprecated and will be removed in a future version of Roughly Enough Items. Please use \"rei_server\", \"rei_client\" or \"rei_common\" instead.".formatted(container.getProvider().getMetadata().getName(), name2));
                }
                if (!pluginClass.isAssignableFrom((plugin = (REIPluginProvider)container.getEntrypoint()).getPluginProviderClass())) continue;
                consumer.accept(new REIPluginProvider<P>(){

                    @Override
                    public Collection<P> provide() {
                        return plugin.provide();
                    }

                    @Override
                    public Class<P> getPluginProviderClass() {
                        return plugin.getPluginProviderClass();
                    }

                    @Override
                    public String getPluginProviderName() {
                        return plugin.getPluginProviderName() + " [" + container.getProvider().getMetadata().getId() + "]";
                    }
                });
            }
            catch (Throwable t) {
                for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
                    if (throwable.getMessage() == null || !throwable.getMessage().contains("environment type SERVER") || PrimitivePlatformAdapter.get().isClient()) continue;
                    RoughlyEnoughItemsState.error("Rerached side issue when loading REI plugin by %s. Please use \"rei_server\", \"rei_client\" or \"rei_common\" instead.".formatted(container.getProvider().getMetadata().getName()));
                    continue block2;
                }
                String error = "Could not create REI Plugin [" + PluginDetectorImpl.getSimpleName(pluginClass) + "] due to errors, provided by '" + container.getProvider().getMetadata().getId() + "'!";
                new RuntimeException(error, t).printStackTrace();
                RoughlyEnoughItemsState.error(error);
            }
        }
    }

    private static <P> String getSimpleName(Class<? extends P> pluginClass) {
        String simpleName = pluginClass.getSimpleName();
        if (simpleName == null) {
            return pluginClass.getName();
        }
        return simpleName;
    }

    @Override
    public void detectServerPlugins() {
        PluginDetectorImpl.loadPlugin(REIServerPlugin.class, ((PluginView)((Object)PluginManager.getServerInstance()))::registerPlugin);
        try {
            PluginView.getServerInstance().registerPlugin((REIServerPlugin)Class.forName("me.shedaniel.rei.impl.common.compat.FabricFluidAPISupportPlugin").getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void detectCommonPlugins() {
        PluginDetectorImpl.loadPlugin(REIPlugin.class, ((PluginView)((Object)PluginManager.getInstance()))::registerPlugin);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public java.util.function.Supplier<Runnable> detectClientPlugins() {
        return () -> () -> {
            PluginDetectorImpl.loadPlugin(REIClientPlugin.class, ((PluginView)((Object)PluginManager.getClientInstance()))::registerPlugin);
            Supplier method = Suppliers.memoize(() -> {
                String methodName = FabricLoader.getInstance().isDevelopmentEnvironment() ? FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_332", "method_51442", "(Ljava/util/List;Lnet/minecraft/class_5632;)V") : "method_51442";
                try {
                    Method declaredMethod = class_332.class.getDeclaredMethod(methodName, List.class, class_5632.class);
                    if (declaredMethod != null) {
                        declaredMethod.setAccessible(true);
                    }
                    return declaredMethod;
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            });
            ClientInternals.attachInstance((arg_0, arg_1) -> PluginDetectorImpl.lambda$detectClientPlugins$4((java.util.function.Supplier)method, arg_0, arg_1), "clientTooltipComponentProvider");
        };
    }

    private static /* synthetic */ void lambda$detectClientPlugins$4(java.util.function.Supplier method, List lines, class_5632 component) {
        try {
            ((Method)method.get()).invoke(null, lines, component);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

