/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.collapsed;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_2960;

public class CollapsedEntriesCache {
    private static CollapsedEntriesCache instance = new CollapsedEntriesCache();
    private final Long2ObjectMap<Set<class_2960>> cache = new Long2ObjectOpenHashMap();

    public static void reset() {
        instance = new CollapsedEntriesCache();
    }

    public static CollapsedEntriesCache getInstance() {
        return instance;
    }

    public void prepare(Collection<HashedEntryStackWrapper> stacks) {
        Collection<CollapsibleEntryRegistryImpl.Entry> entries = ((CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance()).getEntries();
        InternalLogger.getInstance().debug("Preparing collapsed entry groups cache with %d entries and %d stacks", entries.size(), stacks.size());
        ArrayList futures = Lists.newArrayList();
        for (CollapsibleEntryRegistryImpl.Entry entry : entries) {
            if (!entry.canCache()) continue;
            for (HashedEntryStackWrapper stack : stacks) {
                if (entry.getMatcher().matches(stack.unwrap(), stack.hashExact())) {
                    ((Set)this.cache.computeIfAbsent(stack.hashExact(), $ -> new HashSet())).add(entry.getId());
                    continue;
                }
                Set locations = (Set)this.cache.get(stack.hashExact());
                if (locations == null) continue;
                locations.remove(entry.getId());
                if (!locations.isEmpty()) continue;
                this.cache.remove(stack.hashExact());
            }
        }
        InternalLogger.getInstance().debug("Prepared collapsed entry groups cache with %d entries and %d stacks", entries.size(), stacks.size());
    }

    @Nullable
    public Set<class_2960> getEntries(long hash) {
        return (Set)this.cache.get(hash);
    }
}

