/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;

public class TabContainerWidget {
    private final Rectangle bounds = new Rectangle();
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final NumberAnimator<Double> scrollAnimator = ValueAnimator.ofDouble();
    private boolean isCompactTabs;
    private boolean isCompactTabButtons;
    private int tabSize;
    private int tabButtonsSize;
    private int tabsPerPage = 5;

    public void setBounds(Rectangle bounds) {
        this.bounds.setBounds(bounds);
    }

    public void updateScroll(List<DisplayCategory<?>> categories, int selectedCategory, long duration) {
        this.initTabsVariables();
        if (categories.size() <= this.tabsPerPage) {
            this.scrollAnimator.setAs(0.0);
        } else if (selectedCategory < this.tabsPerPage / 2) {
            this.scrollAnimator.setTo(0.0, duration);
        } else if (selectedCategory >= categories.size() - (int)Math.ceil(this.tabsPerPage / 2)) {
            this.scrollAnimator.setTo((categories.size() - this.tabsPerPage) * this.tabSize, duration);
        } else {
            this.scrollAnimator.setTo(((double)selectedCategory - (double)(this.tabsPerPage - 1) / 2.0) * (double)this.tabSize, duration);
        }
    }

    private void initTabsVariables() {
        this.isCompactTabs = ConfigObject.getInstance().isUsingCompactTabs();
        this.isCompactTabButtons = ConfigObject.getInstance().isUsingCompactTabButtons();
        this.tabSize = this.isCompactTabs ? 24 : 28;
        this.tabButtonsSize = this.isCompactTabButtons ? 10 : 16;
    }

    public void initTabsSize(int width) {
        this.initTabsVariables();
        this.tabsPerPage = class_3532.method_15375((float)((width - 6) / this.tabSize));
        if (this.tabsPerPage % 2 == 0) {
            --this.tabsPerPage;
        }
    }

    public void init(final Rectangle scissorsBounds, final Rectangle bounds, final List<DisplayCategory<?>> categories, IntValue categoryPages, final IntValue selectedCategory, Runnable reInit) {
        this.setBounds(bounds);
        this.widgets.clear();
        this.initTabsSize(bounds.width);
        if (categoryPages.getAsInt() == -1) {
            categoryPages.accept(Math.max(0, selectedCategory.getAsInt() / this.tabsPerPage()));
        }
        if (categories.size() > this.tabsPerPage) {
            Button tabLeft = Widgets.createButton(new Rectangle(bounds.x, bounds.getMaxY() - this.tabSize + 1 - this.tabButtonsSize, this.tabButtonsSize, this.tabButtonsSize), (class_2561)class_2561.method_43473()).onClick(button -> {
                int currentCategoryPage = selectedCategory.getAsInt() / this.tabsPerPage();
                currentCategoryPage = Math.floorMod(currentCategoryPage - 1, categories.size() / this.tabsPerPage() + 1);
                selectedCategory.accept(class_3532.method_15340((int)(currentCategoryPage * this.tabsPerPage() + this.tabsPerPage() / 2), (int)(this.tabsPerPage() / 2), (int)(categories.size() - (int)Math.ceil((double)this.tabsPerPage() / 2.0))));
            }).tooltipLine((class_2561)class_2561.method_43471((String)"text.rei.previous_page"));
            this.widgets.add(tabLeft);
            Button tabRight = Widgets.createButton(new Rectangle(bounds.x + bounds.width - this.tabButtonsSize - (this.isCompactTabButtons ? 0 : 1), bounds.getMaxY() - this.tabSize + 1 - this.tabButtonsSize, this.tabButtonsSize, this.tabButtonsSize), (class_2561)class_2561.method_43473()).onClick(button -> {
                int currentCategoryPage = selectedCategory.getAsInt() / this.tabsPerPage();
                currentCategoryPage = Math.floorMod(currentCategoryPage + 1, categories.size() / this.tabsPerPage() + 1);
                selectedCategory.accept(class_3532.method_15340((int)(currentCategoryPage * this.tabsPerPage() + this.tabsPerPage() / 2), (int)(this.tabsPerPage() / 2), (int)(categories.size() - (int)Math.ceil((double)this.tabsPerPage() / 2.0))));
            }).tooltipLine((class_2561)class_2561.method_43471((String)"text.rei.next_page"));
            this.widgets.add(tabRight);
            this.widgets.add(Widgets.withTranslate(Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
                Rectangle tabLeftBounds = tabLeft.getBounds();
                Rectangle tabRightBounds = tabRight.getBounds();
                if (this.isCompactTabButtons) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_22904(0.0, 0.5, 0.0);
                    graphics.method_25290(InternalTextures.ARROW_LEFT_SMALL_TEXTURE, tabLeftBounds.x + 2, tabLeftBounds.y + 2, 0.0f, 0.0f, 6, 6, 6, 6);
                    graphics.method_25290(InternalTextures.ARROW_RIGHT_SMALL_TEXTURE, tabRightBounds.x + 2, tabRightBounds.y + 2, 0.0f, 0.0f, 6, 6, 6, 6);
                    graphics.method_51448().method_22909();
                } else {
                    graphics.method_25290(InternalTextures.ARROW_LEFT_TEXTURE, tabLeftBounds.x + 4, tabLeftBounds.y + 4, 0.0f, 0.0f, 8, 8, 8, 8);
                    graphics.method_25290(InternalTextures.ARROW_RIGHT_TEXTURE, tabRightBounds.x + 4, tabRightBounds.y + 4, 0.0f, 0.0f, 8, 8, 8, 8);
                }
            }), 0.0, 0.0, 1.0));
        }
        this.widgets.add(new Widget(){

            public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
                int left;
                TabContainerWidget.this.scrollAnimator.update((double)delta);
                int absLeft = bounds.x + bounds.width / 2 - TabContainerWidget.this.tabsPerPage() * TabContainerWidget.this.tabSize / 2;
                int absRight = bounds.x + bounds.width / 2 + TabContainerWidget.this.tabsPerPage() * TabContainerWidget.this.tabSize / 2;
                if (categories.size() > TabContainerWidget.this.tabsPerPage()) {
                    left = bounds.x + bounds.width / 2 - Math.min(categories.size(), TabContainerWidget.this.tabsPerPage()) * TabContainerWidget.this.tabSize / 2 - (int)Math.round(TabContainerWidget.this.scrollAnimator.doubleValue());
                    TabContainerWidget.this.updateScroll(categories, selectedCategory.getAsInt(), 300L);
                } else {
                    left = bounds.x + bounds.width / 2 - categories.size() * TabContainerWidget.this.tabSize / 2;
                }
                for (TabWidget tab : Widgets.walk(TabContainerWidget.this.widgets(), widget -> widget instanceof TabWidget)) {
                    tab.getBounds().x = left;
                    left += TabContainerWidget.this.tabSize;
                    if (tab.isSelected()) {
                        tab.opacity = 1.0f;
                    } else if (tab.getBounds().getCenterX() <= absLeft) {
                        tab.opacity = 1.0f - (float)(absLeft - tab.getBounds().getCenterX()) / 20.0f;
                        tab.opacity = (float)Math.pow(class_3532.method_15363((float)tab.opacity, (float)0.0f, (float)1.0f), 1.2);
                    } else if (tab.getBounds().getCenterX() >= absRight) {
                        tab.opacity = 1.0f - (float)(tab.getBounds().getCenterX() - absRight) / 20.0f;
                        tab.opacity = (float)Math.pow(class_3532.method_15363((float)tab.opacity, (float)0.0f, (float)1.0f), 1.2);
                    } else {
                        tab.opacity = 1.0f;
                    }
                    if ((double)tab.opacity < 0.1) {
                        tab.opacity = 0.0f;
                    }
                    if (tab.opacity != 0.0f && tab.getBounds().x <= bounds.getMaxX() && tab.getBounds().getMaxX() >= bounds.x) continue;
                    tab.getBounds().x = -1000;
                    tab.opacity = 0.0f;
                }
            }

            @Override
            public double getZRenderingPriority() {
                return -1000.0;
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public boolean method_25401(double mouseX, double mouseY, double amount) {
                if (TabContainerWidget.this.bounds.contains(mouseX, mouseY) && categories.size() > 1) {
                    int currentCategoryIndex = selectedCategory.getAsInt();
                    if (amount > 0.0) {
                        if (--currentCategoryIndex < 0) {
                            currentCategoryIndex = categories.size() - 1;
                        }
                    } else if (++currentCategoryIndex >= categories.size()) {
                        currentCategoryIndex = 0;
                    }
                    selectedCategory.accept(currentCategoryIndex);
                    return true;
                }
                return false;
            }
        });
        for (int id = 0; id < categories.size(); ++id) {
            int tabIndex = id;
            DisplayCategory<?> category = categories.get(tabIndex);
            TabWidget tab = TabWidget.create(id, this.tabSize, bounds.x + bounds.width / 2 - this.tabsPerPage * this.tabSize / 2, bounds.getMaxY(), 0, this.isCompactTabs ? 166 : 192, widget -> {
                Widgets.produceClickSound();
                if (tabIndex == selectedCategory.getAsInt()) {
                    return false;
                }
                selectedCategory.accept(tabIndex);
                return true;
            });
            tab.setRenderer(category, category.getIcon(), category.getTitle(), tabIndex == selectedCategory.getAsInt());
            this.widgets.add(new DelegateWidget(tab){

                @Override
                public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
                    try (CloseableScissors scissors = Widget.scissor(graphics, new Rectangle(scissorsBounds.x, scissorsBounds.y, scissorsBounds.width, scissorsBounds.height + 4));){
                        super.method_25394(graphics, mouseX, mouseY, delta);
                    }
                }
            });
        }
    }

    public List<Widget> widgets() {
        return this.widgets;
    }

    public int tabsPerPage() {
        return this.tabsPerPage;
    }

    public int tabButtonsSize() {
        return this.tabButtonsSize;
    }

    public int tabSize() {
        return this.tabSize;
    }
}

