/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.wrapper;

import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.mod.util.color.NoColor;
import dev.latvian.mods.rhino.mod.util.color.SimpleColor;
import dev.latvian.mods.rhino.mod.util.color.SimpleColorWithAlpha;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1767;

public interface ColorWrapper {
    public static final Map<String, Color> MAP = new HashMap<String, Color>();
    public static final Map<String, class_124> TEXT = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_124 c : class_124.values()) {
            map.put(c.method_537(), c);
        }
    });
    public static final Map<String, class_1767> DYE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_1767 c : class_1767.values()) {
            map.put(c.method_7792(), c);
        }
    });
    public static final Color NONE = ColorWrapper.createMapped(new NoColor(), "NONE", "none", "", "-", "transparent");
    public static final Color BLACK = ColorWrapper.createMapped(class_124.field_1074, "BLACK", "black");
    public static final Color DARK_BLUE = ColorWrapper.createMapped(class_124.field_1058, "DARK_BLUE", "dark_blue", "darkBlue");
    public static final Color DARK_GREEN = ColorWrapper.createMapped(class_124.field_1077, "DARK_GREEN", "dark_green", "darkGreen");
    public static final Color DARK_AQUA = ColorWrapper.createMapped(class_124.field_1062, "DARK_AQUA", "dark_aqua", "darkAqua");
    public static final Color DARK_RED = ColorWrapper.createMapped(class_124.field_1079, "DARK_RED", "dark_red", "darkRed");
    public static final Color DARK_PURPLE = ColorWrapper.createMapped(class_124.field_1064, "DARK_PURPLE", "dark_purple", "darkPurple");
    public static final Color GOLD = ColorWrapper.createMapped(class_124.field_1065, "GOLD", "gold");
    public static final Color GRAY = ColorWrapper.createMapped(class_124.field_1080, "GRAY", "gray");
    public static final Color DARK_GRAY = ColorWrapper.createMapped(class_124.field_1063, "DARK_GRAY", "dark_gray", "darkGray");
    public static final Color BLUE = ColorWrapper.createMapped(class_124.field_1078, "BLUE", "blue");
    public static final Color GREEN = ColorWrapper.createMapped(class_124.field_1060, "GREEN", "green");
    public static final Color AQUA = ColorWrapper.createMapped(class_124.field_1075, "AQUA", "aqua");
    public static final Color RED = ColorWrapper.createMapped(class_124.field_1061, "RED", "red");
    public static final Color LIGHT_PURPLE = ColorWrapper.createMapped(class_124.field_1076, "LIGHT_PURPLE", "light_purple", "lightPurple");
    public static final Color YELLOW = ColorWrapper.createMapped(class_124.field_1054, "YELLOW", "yellow");
    public static final Color WHITE = ColorWrapper.createMapped(class_124.field_1068, "WHITE", "white");
    public static final Color WHITE_DYE = ColorWrapper.createMapped(class_1767.field_7952, "WHITE_DYE", "white_dye", "whiteDye");
    public static final Color ORANGE_DYE = ColorWrapper.createMapped(class_1767.field_7946, "ORANGE_DYE", "orange_dye", "orangeDye");
    public static final Color MAGENTA_DYE = ColorWrapper.createMapped(class_1767.field_7958, "MAGENTA_DYE", "magenta_dye", "magentaDye");
    public static final Color LIGHT_BLUE_DYE = ColorWrapper.createMapped(class_1767.field_7951, "LIGHT_BLUE_DYE", "light_blue_dye", "lightBlueDye");
    public static final Color YELLOW_DYE = ColorWrapper.createMapped(class_1767.field_7947, "YELLOW_DYE", "yellow_dye", "yellowDye");
    public static final Color LIME_DYE = ColorWrapper.createMapped(class_1767.field_7961, "LIME_DYE", "lime_dye", "limeDye");
    public static final Color PINK_DYE = ColorWrapper.createMapped(class_1767.field_7954, "PINK_DYE", "pink_dye", "pinkDye");
    public static final Color GRAY_DYE = ColorWrapper.createMapped(class_1767.field_7944, "GRAY_DYE", "gray_dye", "grayDye");
    public static final Color LIGHT_GRAY_DYE = ColorWrapper.createMapped(class_1767.field_7967, "LIGHT_GRAY_DYE", "lightGrayDye", "lightGrayDye");
    public static final Color CYAN_DYE = ColorWrapper.createMapped(class_1767.field_7955, "CYAN_DYE", "cyan_dye", "cyanDye");
    public static final Color PURPLE_DYE = ColorWrapper.createMapped(class_1767.field_7945, "PURPLE_DYE", "purple_dye", "purpleDye");
    public static final Color BLUE_DYE = ColorWrapper.createMapped(class_1767.field_7966, "BLUE_DYE", "blue_dye", "blueDye");
    public static final Color BROWN_DYE = ColorWrapper.createMapped(class_1767.field_7957, "BROWN_DYE", "brown_dye", "brownDye");
    public static final Color GREEN_DYE = ColorWrapper.createMapped(class_1767.field_7942, "GREEN_DYE", "green_dye", "greenDye");
    public static final Color RED_DYE = ColorWrapper.createMapped(class_1767.field_7964, "RED_DYE", "red_dye", "redDye");
    public static final Color BLACK_DYE = ColorWrapper.createMapped(class_1767.field_7963, "BLACK_DYE", "black_dye", "blackDye");

    public static Color of(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            String s = o.toString();
            Color c = MAP.get(s);
            if (c != null) {
                return c;
            }
            if (s.startsWith("#")) {
                int col = Long.decode(s).intValue();
                return s.length() == 7 ? new SimpleColor(col) : new SimpleColorWithAlpha(col);
            }
            return NONE;
        }
        if (o instanceof Number) {
            int i = ((Number)o).intValue();
            if (i == 0) {
                return NONE;
            }
            return new SimpleColor(i);
        }
        return NONE;
    }

    public static Color createMapped(Object o, String ... names) {
        Color c = ColorWrapper.of(o);
        for (String s : names) {
            MAP.put(s, c);
        }
        return c;
    }

    public static Color rgba(int r, int g, int b, int a) {
        return new SimpleColor(r << 16 | g << 8 | b | a << 24);
    }
}

