/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Hashtable;
import dev.latvian.mods.rhino.IdFunctionObject;
import dev.latvian.mods.rhino.IdScriptableObject;
import dev.latvian.mods.rhino.IteratorLikeIterable;
import dev.latvian.mods.rhino.NativeCollectionIterator;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.Undefined;
import java.util.Iterator;

public class NativeSet
extends IdScriptableObject {
    static final String ITERATOR_TAG = "Set Iterator";
    static final SymbolKey GETSIZE = new SymbolKey("[Symbol.getSize]");
    private static final Object SET_TAG = "Set";
    private static final int Id_constructor = 1;
    private static final int Id_add = 2;
    private static final int Id_delete = 3;
    private static final int Id_has = 4;
    private static final int Id_clear = 5;
    private static final int Id_keys = 6;
    private static final int Id_values = 6;
    private static final int Id_entries = 7;
    private static final int Id_forEach = 8;
    private static final int SymbolId_getSize = 9;
    private static final int SymbolId_toStringTag = 10;
    private static final int MAX_PROTOTYPE_ID = 10;
    private final Hashtable entries;
    private boolean instanceOfSet = false;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeSet obj = new NativeSet(cx);
        obj.exportAsJSClass(10, scope, false, cx);
        ScriptableObject desc = (ScriptableObject)cx.newObject(scope);
        desc.put(cx, "enumerable", (Scriptable)desc, (Object)Boolean.FALSE);
        desc.put(cx, "configurable", (Scriptable)desc, (Object)Boolean.TRUE);
        desc.put(cx, "get", (Scriptable)desc, obj.get(cx, GETSIZE, (Scriptable)obj));
        obj.defineOwnProperty(cx, "size", desc);
        if (sealed) {
            obj.sealObject(cx);
        }
    }

    static void loadFromIterable(Context cx, Scriptable scope, ScriptableObject set, Object arg1) {
        if (arg1 == null || Undefined.instance.equals(arg1)) {
            return;
        }
        Object ito = ScriptRuntime.callIterator(cx, scope, arg1);
        if (Undefined.instance.equals(ito)) {
            return;
        }
        ScriptableObject dummy = NativeSet.ensureScriptableObject(cx.newObject(scope, set.getClassName()), cx);
        Callable add = ScriptRuntime.getPropFunctionAndThis(cx, scope, dummy.getPrototype(cx), "add");
        cx.lastStoredScriptable();
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, ito);){
            for (Object val : it) {
                Object finalVal = val == NOT_FOUND ? Undefined.instance : val;
                add.call(cx, scope, set, new Object[]{finalVal});
            }
        }
    }

    private static NativeSet realThis(Scriptable thisObj, IdFunctionObject f, Context cx) {
        if (thisObj == null) {
            throw NativeSet.incompatibleCallError(f, cx);
        }
        try {
            NativeSet ns = (NativeSet)thisObj;
            if (!ns.instanceOfSet) {
                throw NativeSet.incompatibleCallError(f, cx);
            }
            return ns;
        }
        catch (ClassCastException cce) {
            throw NativeSet.incompatibleCallError(f, cx);
        }
    }

    public NativeSet(Context cx) {
        this.entries = new Hashtable(cx);
    }

    @Override
    public String getClassName() {
        return "Set";
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(SET_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj == null) {
                    NativeSet ns = new NativeSet(cx);
                    ns.instanceOfSet = true;
                    if (args.length > 0) {
                        NativeSet.loadFromIterable(cx, scope, ns, args[0]);
                    }
                    return ns;
                }
                throw ScriptRuntime.typeError1(cx, "msg.no.new", "Set");
            }
            case 2: {
                return NativeSet.realThis(thisObj, f, cx).js_add(cx, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 3: {
                return NativeSet.realThis(thisObj, f, cx).js_delete(cx, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 4: {
                return NativeSet.realThis(thisObj, f, cx).js_has(cx, args.length > 0 ? args[0] : Undefined.instance);
            }
            case 5: {
                return NativeSet.realThis(thisObj, f, cx).js_clear(cx);
            }
            case 6: {
                return NativeSet.realThis(thisObj, f, cx).js_iterator(scope, NativeCollectionIterator.Type.VALUES, cx);
            }
            case 7: {
                return NativeSet.realThis(thisObj, f, cx).js_iterator(scope, NativeCollectionIterator.Type.BOTH, cx);
            }
            case 8: {
                return NativeSet.realThis(thisObj, f, cx).js_forEach(cx, scope, args.length > 0 ? args[0] : Undefined.instance, args.length > 1 ? args[1] : Undefined.instance);
            }
            case 9: {
                return NativeSet.realThis(thisObj, f, cx).js_getSize();
            }
        }
        throw new IllegalArgumentException("Set.prototype has no method: " + f.getFunctionName());
    }

    private Object js_add(Context cx, Object k) {
        Object key = k;
        if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
            key = ScriptRuntime.zeroObj;
        }
        this.entries.put(cx, key, key);
        return this;
    }

    private Object js_delete(Context cx, Object arg) {
        Object ov = this.entries.delete(cx, arg);
        return ov != null;
    }

    private Object js_has(Context cx, Object arg) {
        return this.entries.has(cx, arg);
    }

    private Object js_clear(Context cx) {
        this.entries.clear(cx);
        return Undefined.instance;
    }

    private Object js_getSize() {
        return this.entries.size();
    }

    private Object js_iterator(Scriptable scope, NativeCollectionIterator.Type type, Context cx) {
        return new NativeCollectionIterator(scope, ITERATOR_TAG, type, this.entries.iterator(), cx);
    }

    private Object js_forEach(Context cx, Scriptable scope, Object arg1, Object arg2) {
        if (!(arg1 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, arg1);
        }
        Callable f = (Callable)arg1;
        boolean isStrict = cx.isStrictMode();
        Iterator<Hashtable.Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, arg2, scope);
            if (thisObj == null && !isStrict) {
                thisObj = scope;
            }
            if (thisObj == null) {
                thisObj = Undefined.SCRIPTABLE_UNDEFINED;
            }
            Hashtable.Entry e = i.next();
            f.call(cx, scope, thisObj, new Object[]{e.value, e.value, this});
        }
        return Undefined.instance;
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        switch (id) {
            case 9: {
                this.initPrototypeMethod(SET_TAG, id, GETSIZE, "get size", 0, cx);
                return;
            }
            case 10: {
                this.initPrototypeValue(10, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        String fnName = null;
        this.initPrototypeMethod(SET_TAG, id, switch (id) {
            case 1 -> {
                arity = 0;
                yield "constructor";
            }
            case 2 -> {
                arity = 1;
                yield "add";
            }
            case 3 -> {
                arity = 1;
                yield "delete";
            }
            case 4 -> {
                arity = 1;
                yield "has";
            }
            case 5 -> {
                arity = 0;
                yield "clear";
            }
            case 7 -> {
                arity = 0;
                yield "entries";
            }
            case 6 -> {
                arity = 0;
                yield "values";
            }
            case 8 -> {
                arity = 1;
                yield "forEach";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, fnName, arity, cx);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (GETSIZE.equals(k)) {
            return 9;
        }
        if (SymbolKey.ITERATOR.equals(k)) {
            return 6;
        }
        if (SymbolKey.TO_STRING_TAG.equals(k)) {
            return 10;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "add" -> 2;
            case "delete" -> 3;
            case "has" -> 4;
            case "clear" -> 5;
            case "keys" -> 6;
            case "values" -> 6;
            case "entries" -> 7;
            case "forEach" -> 8;
            default -> 0;
        };
    }
}

