/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.SequencerTileEntity;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;

public class GuiSequencer
extends GenericGuiContainer<SequencerTileEntity, GenericContainer> {
    private List<ImageChoiceLabel> bits = new ArrayList<ImageChoiceLabel>();

    public GuiSequencer(SequencerTileEntity te, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ((LogicSlabBlock)LogicBlockModule.SEQUENCER.get()).getManualEntry());
    }

    public static void register() {
        GuiSequencer.register((ContainerType)((ContainerType)LogicBlockModule.CONTAINER_SEQUENCER.get()), GuiSequencer::new);
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/sequencer.gui"));
        super.func_231160_c_();
        this.initializeFields();
        this.setupEvents();
    }

    private void initializeFields() {
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                int bit = row * 8 + col;
                this.bits.add((ImageChoiceLabel)this.window.findChild("grid" + bit));
            }
        }
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                int bit = row * 8 + col;
                ImageChoiceLabel label = (ImageChoiceLabel)this.window.findChild("grid" + bit);
                label.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getCycleBit(bit) ? 1 : 0);
            }
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.updateFields();
        super.func_230450_a_(matrixStack, partialTicks, x, y);
    }

    private void setupEvents() {
        this.window.event("grid", (source, params) -> {
            int bit = Integer.parseInt(source.getName().substring("grid".length()));
            this.changeBit(bit, (String)params.get(ImageChoiceLabel.PARAM_CHOICE));
        });
        this.window.event("flip", (source, params) -> this.flipGrid());
        this.window.event("clear", (source, params) -> this.fillGrid());
    }

    private void flipGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(1 - bit.getCurrentChoiceIndex());
        }
        ((SequencerTileEntity)this.tileEntity).flipCycleBits();
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, SequencerTileEntity.CMD_FLIPBITS, TypedMap.EMPTY);
    }

    private void fillGrid() {
        for (ImageChoiceLabel bit : this.bits) {
            bit.setCurrentChoice(0);
        }
        ((SequencerTileEntity)this.tileEntity).clearCycleBits();
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, SequencerTileEntity.CMD_CLEARBITS, TypedMap.EMPTY);
    }

    private void changeBit(int bit, String choice) {
        boolean newChoice = "1".equals(choice);
        ((SequencerTileEntity)this.tileEntity).setCycleBit(bit, newChoice);
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, SequencerTileEntity.CMD_SETBIT, TypedMap.builder().put(SequencerTileEntity.PARAM_BIT, (Object)bit).put(SequencerTileEntity.PARAM_CHOICE, (Object)newChoice).build());
    }
}

