/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.DigitTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class DigitRenderer
extends TileEntityRenderer<DigitTileEntity> {
    public static final ResourceLocation[] DIGITS = new ResourceLocation[]{new ResourceLocation("rftoolsutility", "block/logic/machineoutput_0"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_1"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_2"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_3"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_4"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_5"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_6"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_7"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_8"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_9"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_a"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_b"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_c"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_d"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_e"), new ResourceLocation("rftoolsutility", "block/logic/machineoutput_f")};

    public DigitRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(DigitTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        Block block = state.func_177230_c();
        if (!(block instanceof LogicSlabBlock)) {
            return;
        }
        matrixStack.func_227860_a_();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228643_e_());
        LogicFacing logicFacing = (LogicFacing)state.func_177229_b((Property)LogicSlabBlock.LOGIC_FACING);
        Direction facing = logicFacing.getSide();
        RenderHelper.adjustTransformToDirection((MatrixStack)matrixStack, (Direction)facing);
        int level = te.getPowerLevel();
        if (level < 0) {
            level = 0;
        } else if (level > 15) {
            level = 15;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(DIGITS[level]);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        ModelBuilder.FaceRotation rotation = ModelBuilder.FaceRotation.values()[logicFacing.getRotationStep()];
        RenderHelper.renderNorthSouthQuad((IVertexBuilder)builder, (Matrix4f)matrix, (TextureAtlasSprite)sprite, (ModelBuilder.FaceRotation)rotation, (float)0.73f);
        matrixStack.func_227865_b_();
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)LogicBlockModule.TYPE_DIGIT.get()), DigitRenderer::new);
    }
}

