/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class RedstoneChannelTileEntity
extends GenericTileEntity {
    protected final LogicSupport support = new LogicSupport();
    protected int channel = -1;
    @ServerCommand
    public static final Command<?> CMD_RESET = Command.create((String)"reset", (te, player, params) -> te.setChannel(-1));

    public int getChannel(boolean initialize) {
        if (initialize && this.channel == -1) {
            RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(this.field_145850_b);
            this.setChannel(redstoneChannels.newChannel());
            redstoneChannels.save();
        }
        return this.channel;
    }

    public RedstoneChannelTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.func_70296_d();
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.channel = info.func_74762_e("channel");
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("channel", this.channel);
    }
}

