/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.TagSelector;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.InvCheckerDamageMode;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class InvCheckerTileEntity
extends TickingTileEntity {
    private final LogicSupport support = new LogicSupport();
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), 0, 154, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.no()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Inventory Checker").containerSupplier(DefaultContainerProvider.container(LogicBlockModule.CONTAINER_INVCHECKER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @GuiValue
    private int amount = 1;
    @GuiValue
    private int slot = 0;
    @GuiValue(name="damage")
    private InvCheckerDamageMode useDamage = InvCheckerDamageMode.DMG_IGNORE;
    private Tags.IOptionalNamedTag<Item> tag = null;
    private int checkCounter = 0;
    @ServerCommand
    public static final Command<?> CMD_SETTAG = Command.create((String)"inv.setTag", (te, player, params) -> te.setTagByName((String)params.get(TagSelector.PARAM_TAG)));

    public InvCheckerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_INVCHECKER.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/invchecker")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(InvCheckerTileEntity::new));
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.func_70296_d();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.func_70296_d();
    }

    public Tags.IOptionalNamedTag<Item> getTag() {
        return this.tag;
    }

    public void setTag(Tags.IOptionalNamedTag<Item> tag) {
        this.tag = tag;
        this.func_70296_d();
    }

    public void setTagByName(String tagName) {
        this.tag = tagName == null ? null : this.getiNamedTag(tagName);
        this.markDirtyClient();
    }

    private Tags.IOptionalNamedTag<Item> getiNamedTag(String tagName) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation(tagName));
    }

    public String getTagName() {
        return this.tag == null ? null : this.tag.func_230234_a_().toString();
    }

    public InvCheckerDamageMode isUseDamage() {
        return this.useDamage;
    }

    public void setUseDamage(InvCheckerDamageMode useDamage) {
        this.useDamage = useDamage;
        this.func_70296_d();
    }

    protected void tickServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput() ? 15 : 0);
    }

    public boolean checkOutput() {
        Direction inputSide = LogicSupport.getFacing((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity te = this.field_145850_b.func_175625_s(inputPos);
        if (InventoryTools.isInventory((TileEntity)te)) {
            return CapabilityTools.getItemCapabilitySafe((TileEntity)te).map(capability -> {
                int nr;
                ItemStack stack;
                if (this.slot >= 0 && this.slot < capability.getSlots() && !(stack = capability.getStackInSlot(this.slot)).func_190926_b() && (nr = this.isItemMatching(stack)) >= this.amount) {
                    if (this.tag != null) {
                        return this.tag.func_230235_a_((Object)stack.func_77973_b());
                    }
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private int isItemMatching(ItemStack stack) {
        int nr = 0;
        ItemStack matcher = this.items.getStackInSlot(0);
        if (!matcher.func_190926_b()) {
            if (this.useDamage == InvCheckerDamageMode.DMG_MATCH) {
                if (matcher.func_77969_a(stack)) {
                    nr = stack.func_190916_E();
                }
            } else if (matcher.func_77973_b() == stack.func_77973_b()) {
                nr = stack.func_190916_E();
            }
        } else {
            nr = stack.func_190916_E();
        }
        return nr;
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74767_n("rs") ? 15 : 0);
    }

    public void loadInfo(CompoundNBT tagCompound) {
        String tagString;
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (info.func_74764_b("amount")) {
            this.amount = info.func_74762_e("amount");
        }
        if (info.func_74764_b("slot")) {
            this.slot = info.func_74762_e("slot");
        }
        if (info.func_74764_b("tag") && !(tagString = info.func_74779_i("tag")).isEmpty()) {
            this.tag = this.getiNamedTag(tagString);
        }
        if (info.func_74764_b("useDamage")) {
            this.useDamage = info.func_74767_n("useDamage") ? InvCheckerDamageMode.DMG_MATCH : InvCheckerDamageMode.DMG_IGNORE;
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74757_a("rs", this.support.getPowerOutput() > 0);
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("amount", this.amount);
        info.func_74768_a("slot", this.slot);
        if (this.tag != null) {
            info.func_74778_a("tag", this.tag.func_230234_a_().toString());
        }
        info.func_74757_a("useDamage", this.useDamage == InvCheckerDamageMode.DMG_MATCH);
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.tag != null) {
            info.func_74778_a("tag", this.tag.func_230234_a_().toString());
        }
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        String tagString;
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (info.func_74764_b("tag") && !(tagString = info.func_74779_i("tag")).isEmpty()) {
            this.tag = this.getiNamedTag(tagString);
        }
    }
}

