/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class CounterTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    private boolean prevIn = false;
    private int counter = 1;
    @GuiValue
    public static final Value<CounterTileEntity, Integer> VALUE_COUNTER = Value.create((String)"counter", (Type)Type.INTEGER, CounterTileEntity::getCounter, CounterTileEntity::setCounter);
    @GuiValue
    private int current = 0;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Counter").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_COUNTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public CounterTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_COUNTER.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/counter")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(CounterTileEntity::new));
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.func_70296_d();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.func_70296_d();
    }

    protected void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        int newout = 0;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = 15;
            }
            this.func_70296_d();
            this.support.setRedstoneState((GenericTileEntity)this, newout);
        }
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74767_n("rs") ? 15 : 0);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.counter = info.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = info.func_74762_e("current");
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74757_a("rs", this.support.getPowerOutput() > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("counter", this.counter);
        info.func_74768_a("current", this.current);
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
        this.update();
    }
}

