/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.BuffStyle;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class RenderGameOverlayEventHandler {
    private static final int BUFF_ICON_SIZE = 16;
    public static List<PlayerBuff> buffs = null;

    public static void onRender(RenderGameOverlayEvent event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            return;
        }
        RenderGameOverlayEventHandler.renderBuffs(event.getMatrixStack());
    }

    private static void renderBuffs(MatrixStack matrixStack) {
        if (buffs == null || buffs.isEmpty()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        McJtyLib.getPreferencesProperties((PlayerEntity)player).ifPresent(preferences -> {
            BuffStyle style = preferences.getBuffStyle();
            if (style == BuffStyle.OFF) {
                return;
            }
            int x = preferences.getBuffX();
            int y = preferences.getBuffY();
            boolean leftToRight = true;
            switch (style) {
                case TOPLEFT: {
                    break;
                }
                case TOPRIGHT: {
                    leftToRight = false;
                    x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() + x;
                    break;
                }
                case BOTLEFT: {
                    y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() + y;
                    break;
                }
                case BOTRIGHT: {
                    leftToRight = false;
                    x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() + x;
                    y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() + y;
                }
            }
            for (PlayerBuff buff : buffs) {
                Item item = RenderGameOverlayEventHandler.getBuffItem(buff);
                if (item == null) continue;
                ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
                RenderHelper.renderItemStack((MatrixStack)matrixStack, (ItemRenderer)itemRender, (ItemStack)new ItemStack((IItemProvider)item), (int)x, (int)y, (String)"", (boolean)false);
                if (leftToRight) {
                    x += 16;
                    continue;
                }
                x -= 16;
            }
        });
    }

    private static Item getBuffItem(PlayerBuff buff) {
        Item item = null;
        switch (buff) {
            case BUFF_FEATHERFALLING: {
                item = (Item)EnvironmentalModule.FEATHERFALLING_MODULE.get();
                break;
            }
            case BUFF_FEATHERFALLINGPLUS: {
                item = (Item)EnvironmentalModule.FEATHERFALLINGPLUS_MODULE.get();
                break;
            }
            case BUFF_HASTE: {
                item = (Item)EnvironmentalModule.HASTE_MODULE.get();
                break;
            }
            case BUFF_HASTEPLUS: {
                item = (Item)EnvironmentalModule.HASTEPLUS_MODULE.get();
                break;
            }
            case BUFF_REGENERATION: {
                item = (Item)EnvironmentalModule.REGENERATION_MODULE.get();
                break;
            }
            case BUFF_REGENERATIONPLUS: {
                item = (Item)EnvironmentalModule.REGENERATIONPLUS_MODULE.get();
                break;
            }
            case BUFF_SATURATION: {
                item = (Item)EnvironmentalModule.SATURATION_MODULE.get();
                break;
            }
            case BUFF_SATURATIONPLUS: {
                item = (Item)EnvironmentalModule.SATURATIONPLUS_MODULE.get();
                break;
            }
            case BUFF_SPEED: {
                item = (Item)EnvironmentalModule.SPEED_MODULE.get();
                break;
            }
            case BUFF_SPEEDPLUS: {
                item = (Item)EnvironmentalModule.SPEEDPLUS_MODULE.get();
                break;
            }
            case BUFF_FLIGHT: {
                item = (Item)EnvironmentalModule.FLIGHT_MODULE.get();
                break;
            }
            case BUFF_PEACEFUL: {
                item = (Item)EnvironmentalModule.PEACEFUL_MODULE.get();
                break;
            }
            case BUFF_GLOWING: {
                item = (Item)EnvironmentalModule.GLOWING_MODULE.get();
                break;
            }
            case BUFF_WATERBREATHING: {
                item = (Item)EnvironmentalModule.WATERBREATHING_MODULE.get();
                break;
            }
            case BUFF_NIGHTVISION: {
                item = (Item)EnvironmentalModule.NIGHTVISION_MODULE.get();
                break;
            }
            case BUFF_BLINDNESS: {
                item = (Item)EnvironmentalModule.BLINDNESS_MODULE.get();
                break;
            }
            case BUFF_WEAKNESS: {
                item = (Item)EnvironmentalModule.WEAKNESS_MODULE.get();
                break;
            }
            case BUFF_POISON: {
                item = (Item)EnvironmentalModule.POISON_MODULE.get();
                break;
            }
            case BUFF_SLOWNESS: {
                item = (Item)EnvironmentalModule.SLOWNESS_MODULE.get();
                break;
            }
            case BUFF_LUCK: {
                item = (Item)EnvironmentalModule.LUCK_MODULE.get();
                break;
            }
            case BUFF_NOTELEPORT: {
                item = (Item)EnvironmentalModule.NOTELEPORT_MODULE.get();
                break;
            }
            default: {
                item = null;
            }
        }
        return item;
    }
}

