/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiFunction;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class DimletPackages {
    public static void writePackage(String filename, String modid) throws IOException {
        Path configPath = FMLPaths.CONFIGDIR.get();
        new File(configPath + File.separator + "rftoolsdim").mkdirs();
        JsonArray root = new JsonArray();
        DimletPackages.writeBlocks(root, modid);
        DimletPackages.writeFluids(root, modid);
        DimletPackages.writeBiomes(root, modid);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)root);
        File file = new File(configPath + File.separator + "rftoolsdim" + File.separator + filename);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
    }

    private static void writeBiomes(JsonArray root, String modid) {
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            ResourceLocation id = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (!modid.toLowerCase().equals(id.func_110624_b())) continue;
            JsonObject object = new JsonObject();
            object.addProperty("type", DimletType.BIOME.name().toLowerCase());
            object.addProperty("key", id.toString());
            DimletSettings settings = DimletSettings.create(DimletRarity.COMMON, 10, 10, 1).dimlet(true).worldgen(true).build();
            settings.buildElement(object);
            root.add((JsonElement)object);
        }
    }

    private static void writeFluids(JsonArray root, String modid) {
        for (Map.Entry entry : ForgeRegistries.FLUIDS.getEntries()) {
            Fluid fluid;
            ResourceLocation id = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (!modid.toLowerCase().equals(id.func_110624_b()) || (fluid = (Fluid)entry.getValue()).func_207188_f().func_206883_i().func_177230_c() == Blocks.field_150350_a) continue;
            JsonObject object = new JsonObject();
            object.addProperty("type", DimletType.FLUID.name().toLowerCase());
            object.addProperty("key", id.toString());
            DimletSettings settings = DimletSettings.create(DimletRarity.COMMON, 10, 10, 10).dimlet(true).worldgen(true).build();
            settings.buildElement(object);
            root.add((JsonElement)object);
        }
    }

    private static void writeBlocks(JsonArray root, String modid) {
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Block block;
            boolean hasTileEntity;
            ResourceLocation id = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (!modid.toLowerCase().equals(id.func_110624_b()) || (hasTileEntity = (block = (Block)entry.getValue()).hasTileEntity(block.func_176223_P()))) continue;
            boolean isOre = block.getTags().contains(Tags.Blocks.ORES.func_230234_a_());
            JsonObject object = new JsonObject();
            object.addProperty("type", DimletType.BLOCK.name().toLowerCase());
            object.addProperty("key", id.toString());
            DimletSettings settings = DimletSettings.create(isOre ? DimletRarity.UNCOMMON : DimletRarity.COMMON, isOre ? 100 : 10, isOre ? 100 : 10, isOre ? 100 : 10).dimlet(true).worldgen(true).build();
            settings.buildElement(object);
            root.add((JsonElement)object);
        }
    }

    public static void readPackage(String filename, BiFunction<DimletKey, DimletSettings, Boolean> consumer) {
        InputStream inputStream = null;
        Path configPath = FMLPaths.CONFIGDIR.get();
        new File(configPath + File.separator + "rftoolsdim").mkdirs();
        File file = new File(configPath + File.separator + "rftoolsdim" + File.separator + filename);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (inputStream == null && (inputStream = RFToolsDim.class.getResourceAsStream("/data/rftoolsdim/dimletpackages/" + filename)) == null) {
            RFToolsDim.setup.getLogger().error("Can't find dimlet package: " + filename);
            throw new IllegalStateException("Can't find dimlet package: " + filename);
        }
        int cnt = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement root = parser.parse((Reader)br);
            JsonArray array = root.getAsJsonArray();
            for (JsonElement element : array) {
                DimletSettings settings;
                JsonObject object = element.getAsJsonObject();
                String type = object.getAsJsonPrimitive("type").getAsString();
                String key = object.getAsJsonPrimitive("key").getAsString();
                DimletKey dimletKey = new DimletKey(DimletType.byName(type), key);
                Boolean success = consumer.apply(dimletKey, settings = DimletSettings.parse(object));
                if (!Boolean.TRUE.equals(success)) continue;
                ++cnt;
            }
        }
        catch (IOException ex) {
            RFToolsDim.setup.getLogger().error("Error loading dimlet package: " + filename);
            throw new UncheckedIOException(ex);
        }
        RFToolsDim.setup.getLogger().info("Reading dimlet package: " + filename + ", " + cnt + " valid dimlets found");
    }
}

