/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.terraintypes;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.terraintypes.FlatChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.IslandsChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.NormalChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.VoidChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.WavesChunkGenerator;
import mcjty.rftoolsdim.modules.knowledge.data.KnowledgeSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.gen.ChunkGenerator;

public enum TerrainType {
    FLAT("flat", KnowledgeSet.SET1, FlatChunkGenerator::new),
    WAVES("waves", KnowledgeSet.SET1, WavesChunkGenerator::new),
    VOID("void", KnowledgeSet.SET2, VoidChunkGenerator::new),
    NORMAL("normal", KnowledgeSet.SET3, NormalChunkGenerator::new),
    ISLANDS("islands", KnowledgeSet.SET4, IslandsChunkGenerator::new);

    private final String name;
    private final KnowledgeSet set;
    private final BiFunction<MinecraftServer, DimensionSettings, ChunkGenerator> generatorSupplier;
    private static final Map<String, TerrainType> TERRAIN_BY_NAME;

    private TerrainType(String name, KnowledgeSet set, BiFunction<MinecraftServer, DimensionSettings, ChunkGenerator> generatorSupplier) {
        this.name = name;
        this.set = set;
        this.generatorSupplier = generatorSupplier;
    }

    public String getName() {
        return this.name;
    }

    public KnowledgeSet getSet() {
        return this.set;
    }

    public BiFunction<MinecraftServer, DimensionSettings, ChunkGenerator> getGeneratorSupplier() {
        return this.generatorSupplier;
    }

    public static TerrainType byName(String name) {
        return TERRAIN_BY_NAME.get(name.toLowerCase());
    }

    static {
        TERRAIN_BY_NAME = new HashMap<String, TerrainType>();
        for (TerrainType type : TerrainType.values()) {
            TERRAIN_BY_NAME.put(type.getName(), type);
        }
    }
}

