/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.descriptor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DimensionDescriptor {
    private final List<DimletKey> dimlets = new ArrayList<DimletKey>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Gson GSON_COMPACT = new GsonBuilder().disableHtmlEscaping().create();
    public static final DimensionDescriptor EMPTY = new DimensionDescriptor();

    public List<DimletKey> getDimlets() {
        return this.dimlets;
    }

    public void read(String json) {
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        JsonArray object = root.getAsJsonArray();
        this.read(object);
    }

    public void read(JsonArray object) {
        this.dimlets.clear();
        for (JsonElement element : object) {
            JsonObject dimletJson = element.getAsJsonObject();
            String type = dimletJson.has("type") ? dimletJson.getAsJsonPrimitive("type").getAsString() : dimletJson.getAsJsonPrimitive("t").getAsString();
            DimletType dimletType = DimletType.byName(type);
            String name = dimletJson.has("name") ? dimletJson.get("name").getAsString() : dimletJson.get("n").getAsString();
            DimletKey dimletDescriptor = new DimletKey(dimletType, name);
            this.dimlets.add(dimletDescriptor);
        }
    }

    public String write() {
        JsonArray root = new JsonArray();
        for (DimletKey dimletDescriptor : this.dimlets) {
            JsonObject dimletJson = new JsonObject();
            dimletJson.addProperty("type", dimletDescriptor.getType().name());
            dimletJson.addProperty("name", dimletDescriptor.getKey());
            root.add((JsonElement)dimletJson);
        }
        return GSON.toJson((JsonElement)root);
    }

    public String compact() {
        JsonArray root = new JsonArray();
        for (DimletKey dimletDescriptor : this.dimlets) {
            JsonObject dimletJson = new JsonObject();
            dimletJson.addProperty("t", dimletDescriptor.getType().getShortName());
            dimletJson.addProperty("n", dimletDescriptor.getKey());
            root.add((JsonElement)dimletJson);
        }
        return GSON_COMPACT.toJson((JsonElement)root);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionDescriptor that = (DimensionDescriptor)o;
        return Objects.equals(this.dimlets, that.dimlets);
    }

    public int hashCode() {
        return Objects.hash(this.dimlets);
    }

    public void dump(PlayerEntity player) {
        for (DimletKey dimlet : this.dimlets) {
            player.func_146105_b((ITextComponent)new StringTextComponent(dimlet.getType().name() + ": ").func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new StringTextComponent(dimlet.getKey()).func_240699_a_(TextFormatting.WHITE)), false);
        }
    }

    public DimensionDescriptor createRandomizedDescriptor(Random random) {
        DimletKey timeDimlet;
        DimletKey controllerDimlet;
        DimletKey terrainDimlet;
        DimensionDescriptor randomizedDescriptor = new DimensionDescriptor();
        List<DimletKey> dimlets = this.getDimlets();
        List<DimletKey> randomized = randomizedDescriptor.getDimlets();
        if (!this.hasTerrain(dimlets) && (terrainDimlet = DimletDictionary.get().getRandomDimlet(DimletType.TERRAIN, random)) != null) {
            this.addBlockDimlets(randomized, random);
            this.addAttributeDimlets(randomized, random);
            this.addFluidDimlets(randomized, random, 1);
            randomized.add(terrainDimlet);
        }
        if (!this.hasFeatures(dimlets)) {
            int cnt = random.nextInt(3);
            for (int i = 0; i < cnt; ++i) {
                DimletKey featureDimlet = DimletDictionary.get().getRandomDimlet(DimletType.FEATURE, random);
                if (featureDimlet == null) continue;
                this.addBlockDimlets(randomized, random);
                randomized.add(featureDimlet);
            }
        }
        if (!this.hasBiomeController(dimlets) && (controllerDimlet = DimletDictionary.get().getRandomDimlet(DimletType.BIOME_CONTROLLER, random)) != null) {
            this.addBiomeDimlets(randomized, random);
            randomized.add(controllerDimlet);
        }
        if (!this.hasTimeDimlet(dimlets) && (timeDimlet = DimletDictionary.get().getRandomDimlet(DimletType.TIME, random)) != null) {
            randomized.add(timeDimlet);
        }
        return randomizedDescriptor;
    }

    private void addAttributeDimlets(List<DimletKey> randomized, Random random) {
        int cnt = random.nextInt(3);
        for (int i = 0; i < cnt; ++i) {
            DimletKey dimlet = DimletDictionary.get().getRandomDimlet(DimletType.ATTRIBUTE, random);
            if (dimlet == null) continue;
            randomized.add(dimlet);
        }
    }

    private void addBiomeDimlets(List<DimletKey> randomized, Random random) {
        int cnt = random.nextInt(8) + 1;
        for (int i = 0; i < cnt; ++i) {
            DimletKey dimlet = DimletDictionary.get().getRandomDimlet(DimletType.BIOME, random);
            if (dimlet == null) continue;
            randomized.add(dimlet);
        }
    }

    private void addFluidDimlets(List<DimletKey> randomized, Random random, int max) {
        int cnt = random.nextInt(Math.min(3, max + 1));
        for (int i = 0; i < cnt; ++i) {
            DimletKey dimlet = DimletDictionary.get().getRandomDimlet(DimletType.FLUID, random);
            if (dimlet == null) continue;
            randomized.add(dimlet);
        }
    }

    private void addBlockDimlets(List<DimletKey> randomized, Random random) {
        int cnt = Math.max(1, random.nextInt(6) - 2);
        for (int i = 0; i < cnt; ++i) {
            DimletKey dimlet = DimletDictionary.get().getRandomDimlet(DimletType.BLOCK, random);
            if (dimlet == null) continue;
            randomized.add(dimlet);
        }
    }

    private boolean hasTerrain(List<DimletKey> dimlets) {
        return dimlets.stream().anyMatch(key -> key.getType() == DimletType.TERRAIN);
    }

    private boolean hasFeatures(List<DimletKey> dimlets) {
        return dimlets.stream().anyMatch(key -> key.getType() == DimletType.FEATURE);
    }

    private boolean hasBiomeController(List<DimletKey> dimlets) {
        return dimlets.stream().anyMatch(key -> key.getType() == DimletType.BIOME_CONTROLLER);
    }

    private boolean hasTimeDimlet(List<DimletKey> dimlets) {
        return dimlets.stream().anyMatch(key -> key.getType() == DimletType.TIME);
    }
}

