/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.tablet.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.filter.network.PacketSyncHandItem;
import mcjty.rftoolsbase.modules.tablet.TabletModule;
import mcjty.rftoolsbase.modules.tablet.items.TabletContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiTablet
extends GenericGuiContainer<GenericTileEntity, TabletContainer> {
    public static final int TABLET_WIDTH = 180;
    public static final int TABLET_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/tablet.png");
    private ToggleButton[] buttons;

    public GuiTablet(TabletContainer container, PlayerInventory inventory) {
        super(null, (Container)container, inventory, TabletItem.MANUAL);
        this.field_146999_f = 180;
        this.field_147000_g = 188;
    }

    public static void register() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TabletModule.CONTAINER_TABLET.get()), GuiTablet::createTabletGui);
    }

    @Nonnull
    private static GuiTablet createTabletGui(TabletContainer container, PlayerInventory inventory, ITextComponent textComponent) {
        return new GuiTablet(container, inventory);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        Panel toplevel = (Panel)Widgets.positional().background(iconLocation);
        this.buttons = new ToggleButton[6];
        for (int i = 0; i < 6; ++i) {
            int finalI = i;
            this.buttons[i] = ((ToggleButton)new ToggleButton().hint(14 + i * 23, 32, 19, 8)).event(() -> this.setActive(finalI));
            toplevel.children(new Widget[]{this.buttons[i]});
        }
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void updateActiveButton(int current) {
        for (int i = 0; i < 6; ++i) {
            this.buttons[i].pressed(i == current);
        }
    }

    private Hand getHand() {
        if (this.field_230706_i_.field_71439_g == null || this.field_230706_i_.field_71439_g.func_184600_cs() == null) {
            return Hand.MAIN_HAND;
        }
        return this.field_230706_i_.field_71439_g.func_184600_cs();
    }

    protected void func_230451_b_(@Nonnull MatrixStack stack, int p_230451_2_, int p_230451_3_) {
        super.func_230451_b_(stack, p_230451_2_, p_230451_3_);
        ItemStack heldItem = this.field_230706_i_.field_71439_g.func_184586_b(this.getHand());
        this.updateActiveButton(TabletItem.getCurrentSlot(heldItem));
    }

    private void setActive(int i) {
        ItemStack heldItem = this.field_230706_i_.field_71439_g.func_184586_b(this.getHand());
        TabletItem.setCurrentSlot((PlayerEntity)this.field_230706_i_.field_71439_g, heldItem, i);
        this.updateActiveButton(i);
        this.syncStack();
    }

    private void syncStack() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSyncHandItem((PlayerEntity)this.field_230706_i_.field_71439_g));
    }
}

