/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.MineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.common.util.Lazy;

public class MineshaftEndStructure
extends MineshaftStructure {
    public MineshaftEndStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int biomeRange, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange, Lazy<Double> probability) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange, probability);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        boolean superCheck = super.isFeatureChunk(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        if (!superCheck) {
            return false;
        }
        int structureCheckRadius = 6;
        for (int curChunkX = chunkX - structureCheckRadius; curChunkX <= chunkZ + structureCheckRadius; ++curChunkX) {
            for (int curChunkZ = chunkZ - structureCheckRadius; curChunkZ <= chunkZ + structureCheckRadius; ++curChunkZ) {
                for (Structure<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.END_MINESHAFT_AVOID_STRUCTURE)) {
                    StructureSeparationSettings structureConfig;
                    if (structureFeature == this || (structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature)) == null || structureConfig.func_236668_a_() <= 10) continue;
                    ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        int minThickness = (Integer)RSMineshaftsConfig.endMineshaftMinIslandThickness.get();
        if (minThickness == 0) {
            return true;
        }
        BlockPos.Mutable islandTopBottomThickness = new BlockPos.Mutable(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int xPos = chunkX * 16;
        int zPos = chunkZ * 16;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = new Vector3f((float)direction.func_82601_c(), 0.0f, (float)direction.func_82599_e());
                offsetPos = new Vector3f(offsetPos.func_195899_a() * 30.0f * (float)i, 0.0f, offsetPos.func_195902_c() * 30.0f * (float)i);
                this.analyzeLand(chunkGenerator, xPos + (int)offsetPos.func_195899_a(), zPos + (int)offsetPos.func_195902_c(), islandTopBottomThickness);
                if (islandTopBottomThickness.func_177952_p() >= minThickness) continue;
                return false;
            }
        }
        this.analyzeLand(chunkGenerator, xPos, zPos, islandTopBottomThickness);
        return islandTopBottomThickness.func_177952_p() >= minThickness;
    }

    private void analyzeLand(ChunkGenerator chunkGenerator, int xPos, int zPos, BlockPos.Mutable islandTopBottomThickness) {
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(xPos, zPos);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(xPos, chunkGenerator.func_230355_e_(), zPos);
        boolean isInIsland = false;
        while (currentPos.func_177956_o() >= -1) {
            BlockState state = columnOfBlocks.func_180495_p((BlockPos)currentPos);
            if (!state.func_196958_f() && !isInIsland) {
                isInIsland = true;
                int topIslandY = Math.min(currentPos.func_177956_o(), islandTopBottomThickness.func_177958_n());
                islandTopBottomThickness.func_181079_c(topIslandY, islandTopBottomThickness.func_177956_o(), islandTopBottomThickness.func_177952_p());
            } else if (state.func_196958_f() && isInIsland || currentPos.func_177956_o() == -1) {
                int bottomIslandY = Math.max(currentPos.func_177956_o(), islandTopBottomThickness.func_177956_o());
                islandTopBottomThickness.func_181079_c(islandTopBottomThickness.func_177958_n(), bottomIslandY, islandTopBottomThickness.func_177952_p());
                break;
            }
            currentPos.func_189536_c(Direction.DOWN);
        }
        if (!isInIsland) {
            islandTopBottomThickness.func_181079_c(0, 0, 0);
        }
        int thickness = islandTopBottomThickness.func_177958_n() - islandTopBottomThickness.func_177956_o();
        islandTopBottomThickness.func_181079_c(islandTopBottomThickness.func_177958_n(), islandTopBottomThickness.func_177956_o(), thickness);
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>>
    extends MineshaftStructure.Builder<T> {
        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        @Override
        public MineshaftEndStructure build() {
            return new MineshaftEndStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.biomeRange, (Lazy<Integer>)this.maxY, (Lazy<Integer>)this.minY, this.clipOutOfBoundsPieces, (Lazy<Integer>)this.verticalRange, (Lazy<Double>)this.probability);
        }
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        private final ResourceLocation structureID;

        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.structureID = Registry.field_218361_B.func_177774_c(structureIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos.Mutable blockpos = new BlockPos.Mutable(chunkX * 16, 0, chunkZ * 16);
            BlockPos.Mutable islandTopBottomThickness = new BlockPos.Mutable(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            MineshaftEndStructure.this.analyzeLand(chunkGenerator, blockpos.func_177958_n(), blockpos.func_177952_p(), islandTopBottomThickness);
            int minThickness = (Integer)RSMineshaftsConfig.endMineshaftMinIslandThickness.get();
            int maxY = 53;
            int minY = 15;
            if (minThickness == 0) {
                blockpos.func_189534_c(Direction.UP, 35);
            } else {
                int structureStartHeight = this.field_214631_d.nextInt(Math.max(islandTopBottomThickness.func_177952_p() - minThickness + 1, 1)) + islandTopBottomThickness.func_177956_o() + minThickness / 2;
                blockpos.func_189534_c(Direction.UP, structureStartHeight);
                maxY = islandTopBottomThickness.func_177958_n() - 5;
                minY = islandTopBottomThickness.func_177956_o();
                if (maxY - minY <= 5) {
                    minY = maxY - 5;
                }
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(MineshaftEndStructure.this.startPool), ((Integer)MineshaftEndStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, (BlockPos)blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false, this.structureID, maxY, minY);
            this.func_202500_a();
        }
    }
}

