/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldSettingsImport;

public class SafeDecodingRegistryOps<T>
extends WorldSettingsImport<T> {
    private final DynamicRegistries dynamicRegistries;
    private final Map<RegistryKey<? extends Registry<?>>, ValueHolder<?>> valueHolders;

    public SafeDecodingRegistryOps(DynamicOps<T> delegate, DynamicRegistries dynamicRegistries) {
        super(delegate, null, null, Maps.newIdentityHashMap());
        this.dynamicRegistries = dynamicRegistries;
        this.valueHolders = Maps.newIdentityHashMap();
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> func_241802_a_(T object, RegistryKey<? extends Registry<E>> registryKey, Codec<E> codec, boolean allowInlineDefinitions) {
        Optional optional = this.dynamicRegistries.func_230521_a_(registryKey);
        if (!optional.isPresent()) {
            return DataResult.error((String)("(Repurposed Structures SafeDecodingRegistryOps) Unknown registry: " + registryKey));
        }
        DataResult dataResult = ResourceLocation.field_240908_a_.decode(this.field_240857_a_, object);
        if (!dataResult.result().isPresent()) {
            return !allowInlineDefinitions ? DataResult.error((String)"(Repurposed Structures SafeDecodingRegistryOps) Inline definitions not allowed here") : codec.decode((DynamicOps)this, object).map(pair -> pair.mapFirst(object2 -> () -> object2));
        }
        MutableRegistry mutableRegistry = (MutableRegistry)optional.get();
        Pair pair2 = (Pair)dataResult.result().get();
        ResourceLocation resourceLocation = (ResourceLocation)pair2.getFirst();
        try {
            return this.readSupplier(registryKey, mutableRegistry, codec, resourceLocation).map(supplier -> Pair.of((Object)supplier, (Object)pair2.getSecond()));
        }
        catch (Exception e) {
            RepurposedStructures.LOGGER.error("\n Repurposed Structures: Crash is about to occur because an entry in a datapack does not exist in a registry or failed to resolve an entry.\n Entry failed to be resolved: {}\n Registry being used: {}", object, registryKey);
            throw e;
        }
    }

    private <E> DataResult<java.util.function.Supplier<E>> readSupplier(RegistryKey<? extends Registry<E>> registryRegistryKey, MutableRegistry<E> mutableRegistry, Codec<E> codec, ResourceLocation elementId) {
        RegistryKey elementRegistryKey = RegistryKey.func_240903_a_(registryRegistryKey, (ResourceLocation)elementId);
        ValueHolder<E> valueHolder = this.getValueHolder(registryRegistryKey);
        DataResult dataResult = (DataResult)((ValueHolder)valueHolder).values.get(elementRegistryKey);
        if (dataResult != null) {
            return dataResult;
        }
        Supplier supplier = Suppliers.memoize(() -> {
            Object object = mutableRegistry.func_230516_a_(elementRegistryKey);
            if (object == null) {
                throw new RuntimeException("(Repurposed Structures SafeDecodingRegistryOps) Error during recursive registry parsing, element resolved too early: " + elementRegistryKey);
            }
            return object;
        });
        ((ValueHolder)valueHolder).values.put(elementRegistryKey, DataResult.success((Object)supplier));
        DataResult dataResult4 = null;
        if (mutableRegistry.func_230516_a_(elementRegistryKey) != null) {
            dataResult4 = DataResult.success(() -> mutableRegistry.func_230516_a_(elementRegistryKey), (Lifecycle)Lifecycle.stable());
        }
        ((ValueHolder)valueHolder).values.put(elementRegistryKey, dataResult4);
        return dataResult4;
    }

    private <E> ValueHolder<E> getValueHolder(RegistryKey<? extends Registry<E>> registryRef) {
        return this.valueHolders.computeIfAbsent(registryRef, registryKey -> new ValueHolder());
    }

    static final class ValueHolder<E> {
        private final Map<RegistryKey<E>, DataResult<java.util.function.Supplier<E>>> values = Maps.newIdentityHashMap();

        private ValueHolder() {
        }
    }
}

