/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class Mineshafts {
    private Mineshafts() {
    }

    public static void addMineshafts(BiomeLoadingEvent event) {
        if ((Double)RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_BIRCH.get(), () -> BiomeSelection.hasName(event, "birch"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_BIRCH);
        }
        if ((Double)RSMineshaftsConfig.jungleMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_JUNGLE.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.JUNGLE))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_JUNGLE);
        }
        if ((Double)RSMineshaftsConfig.desertMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_DESERT.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.DESERT))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_DESERT);
        }
        if ((Double)RSMineshaftsConfig.stoneMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_STONE.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.EXTREME_HILLS))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_STONE);
        }
        if ((Double)RSMineshaftsConfig.savannaMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_SAVANNA.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.SAVANNA))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_SAVANNA);
        }
        if ((Double)RSMineshaftsConfig.icyMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_ICY.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.ICY) || BiomeSelection.hasName(event, "snowy"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_ICY);
        }
        if ((Double)RSMineshaftsConfig.oceanMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_OCEAN.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.OCEAN))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_OCEAN);
        }
        if ((Double)RSMineshaftsConfig.taigaMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_TAIGA.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.TAIGA))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_TAIGA);
        }
        if ((Double)RSMineshaftsConfig.darkForestMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_DARK_FOREST.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_DARK_FOREST);
        }
        if ((Double)RSMineshaftsConfig.swampMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (Structure)RSStructures.MINESHAFT_SWAMP.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.SWAMP))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_SWAMP);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowed(event, (Structure)RSStructures.MINESHAFT_CRIMSON.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.NETHER) && BiomeSelection.hasName(event, "crimson", "_red"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_CRIMSON);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowed(event, (Structure)RSStructures.MINESHAFT_WARPED.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.NETHER) && BiomeSelection.hasName(event, "warped", "blue"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_WARPED);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowed(event, (Structure)RSStructures.MINESHAFT_NETHER.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.NETHER) && !BiomeSelection.hasName(event, "crimson", "_red", "warped", "blue"))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_NETHER);
        }
        if ((Double)RSMineshaftsConfig.endMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowed(event, (Structure)RSStructures.MINESHAFT_END.get(), () -> BiomeSelection.haveCategories(event, Biome.Category.THEEND) && !BiomeSelection.isBiome(event, Biomes.field_76779_k) && ((Integer)RSMineshaftsConfig.endMineshaftMinIslandThickness.get() == 0 || !BiomeSelection.isBiome(event, Biomes.field_201939_S, Biomes.field_201936_P)))) {
            event.getGeneration().getStructures().add(() -> RSConfiguredStructures.MINESHAFT_END);
        }
        if (!RepurposedStructures.yungsBetterMineshaftIsOn && !RepurposedStructures.isCavesAndCliffsBackportOn && BiomeSelection.doesHaveStructureType(event, RSStructureTagMap.STRUCTURE_TAGS.MINESHAFT)) {
            event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == Structure.field_236367_c_);
        }
    }

    private static boolean genericMineshaftCheck(BiomeLoadingEvent context, Structure<?> structureFeature, Supplier<Boolean> condition) {
        return BiomeSelection.isBiomeAllowed(context, structureFeature, () -> BiomeSelection.doesNotHaveStructureType(context, RSStructureTagMap.STRUCTURE_TAGS.MINESHAFT) && (Boolean)condition.get() != false);
    }
}

