/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class NBTHelper {
    private NBTHelper() {
    }

    public static short getShort(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74765_d(s);
    }

    public static void putShort(String s, ItemStack stack, short i) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_74777_a(s, i);
        stack.func_77982_d(tagCompound);
    }

    public static int getInt(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74762_e(s);
    }

    public static void putInt(String s, ItemStack stack, int i) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_74768_a(s, i);
        stack.func_77982_d(tagCompound);
    }

    public static long getLong(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74763_f(s);
    }

    public static void putLong(String s, ItemStack stack, long i) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_74772_a(s, i);
        stack.func_77982_d(tagCompound);
    }

    public static boolean getBoolean(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74767_n(s);
    }

    public static void putBoolean(String s, ItemStack stack, boolean b) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_74757_a(s, b);
        stack.func_77982_d(tagCompound);
    }

    public static String getString(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74779_i(s);
    }

    public static void putString(String s, ItemStack stack, String s1) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_74778_a(s, s1);
        stack.func_77982_d(tagCompound);
    }

    public static CompoundNBT getTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return new CompoundNBT();
        }
        return stack.func_77978_p();
    }

    public static void putTagCompound(String s, ItemStack stack, CompoundNBT tc) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        tagCompound.func_218657_a(s, (INBT)tc);
        stack.func_77982_d(tagCompound);
    }

    public static CompoundNBT getTagCompound(String s, ItemStack stack) {
        CompoundNBT tagCompound = NBTHelper.getTag(stack);
        return tagCompound.func_74775_l(s);
    }

    public static void remove(@Nullable CompoundNBT nbt, String tagName) {
        if (nbt != null) {
            nbt.func_82580_o(tagName);
        }
    }

    public static void removeContainedStacks(ItemStack container) {
        NBTHelper.remove(container.func_77978_p(), "Slots");
    }

    public static void updateContainedStack(ItemStack container, short slot, ItemStack stackToSave, int count) {
        NBTHelper.updateContainedStack(container, slot, stackToSave, count, false);
    }

    public static void updateContainedStack(ItemStack container, short slot, ItemStack stackToSave, int count, boolean updateCountOnly) {
        CompoundNBT slotTag;
        CompoundNBT tag = NBTHelper.getTag(container);
        ListNBT slots = tag.func_150295_c("Slots", 10);
        while (slot > slots.size()) {
            slots.add((Object)NBTHelper.getEmptyStackNBT());
        }
        if (slot == slots.size()) {
            if (updateCountOnly) {
                return;
            }
            slotTag = new CompoundNBT();
            slots.add((Object)slotTag);
        } else {
            slotTag = (CompoundNBT)slots.get((int)slot);
        }
        if (!updateCountOnly) {
            slotTag.func_218657_a("Stack", (INBT)stackToSave.func_77955_b(new CompoundNBT()));
        }
        slotTag.func_74768_a("Count", count);
        slots.set((int)slot, (INBT)slotTag);
        tag.func_218657_a("Slots", (INBT)slots);
        container.func_77982_d(tag);
    }

    public static int getContainedStackCount(ItemStack container, int slot) {
        CompoundNBT tag = NBTHelper.getTag(container);
        ListNBT slots = tag.func_150295_c("Slots", 10);
        if (slot < slots.size()) {
            CompoundNBT slotTag = (CompoundNBT)slots.get(slot);
            return slotTag.func_74762_e("Count");
        }
        return 0;
    }

    public static int getCountContainedStacks(ItemStack container) {
        CompoundNBT tag = NBTHelper.getTag(container);
        ListNBT slots = tag.func_150295_c("Slots", 10);
        return slots.size();
    }

    public static ItemStack getContainedStack(ItemStack container, int slot) {
        CompoundNBT tag = NBTHelper.getTag(container);
        ListNBT slots = tag.func_150295_c("Slots", 10);
        if (slot < slots.size()) {
            CompoundNBT slotTag = (CompoundNBT)slots.get(slot);
            ItemStack ret = ItemStack.func_199557_a((CompoundNBT)slotTag.func_74775_l("Stack"));
            ret.func_190920_e(slotTag.func_74762_e("Count"));
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    private static INBT getEmptyStackNBT() {
        CompoundNBT slotTag = new CompoundNBT();
        slotTag.func_218657_a("Stack", (INBT)ItemStack.field_190927_a.func_77955_b(new CompoundNBT()));
        slotTag.func_74768_a("Count", 0);
        return slotTag;
    }
}

