/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xreliquary.api.IPedestalItemWrapper;

@Mod.EventBusSubscriber(modid="xreliquary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PedestalRegistry {
    private static final PedestalRegistry INSTANCE = new PedestalRegistry();
    private static final Map<LocationKey, BlockPos> positions = new HashMap<LocationKey, BlockPos>();
    private final Map<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>> itemWrappers = new HashMap<Class<? extends Item>, Supplier<? extends IPedestalItemWrapper>>();
    private final Map<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>> blockWrappers = new HashMap<Class<? extends Block>, Supplier<? extends IPedestalItemWrapper>>();

    public static void registerItemWrapper(Class<? extends Item> itemClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.itemWrappers.put(itemClass, wrapperClass);
    }

    public static void registerItemBlockWrapper(Class<? extends Block> blockClass, Supplier<? extends IPedestalItemWrapper> wrapperClass) {
        PedestalRegistry.INSTANCE.blockWrappers.put(blockClass, wrapperClass);
    }

    public static Optional<IPedestalItemWrapper> getItemWrapper(ItemStack item) {
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.itemWrappers.keySet()) {
            if (!clazz.isInstance(item.func_77973_b())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.itemWrappers.get(clazz).get());
        }
        for (Class<? extends Item> clazz : PedestalRegistry.INSTANCE.blockWrappers.keySet()) {
            if (!(item.func_77973_b() instanceof BlockItem) || !clazz.isInstance(((BlockItem)item.func_77973_b()).func_179223_d())) continue;
            return Optional.of(PedestalRegistry.INSTANCE.blockWrappers.get(clazz).get());
        }
        return Optional.empty();
    }

    public static void registerPosition(ResourceLocation dimension, BlockPos pos) {
        LocationKey key = new LocationKey(dimension, pos.func_218275_a());
        if (!positions.containsKey(key)) {
            positions.put(key, pos);
        }
    }

    public static void unregisterPosition(ResourceLocation dimension, BlockPos pos) {
        positions.remove(new LocationKey(dimension, pos.func_218275_a()));
    }

    private static void clearPositions() {
        positions.clear();
    }

    public static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int range) {
        return PedestalRegistry.getPositionsInRange(dimension, startPos, range, range, range);
    }

    private static List<BlockPos> getPositionsInRange(ResourceLocation dimension, BlockPos startPos, int xRange, int yRange, int zRange) {
        ArrayList<BlockPos> positionsInRange = new ArrayList<BlockPos>();
        for (Map.Entry<LocationKey, BlockPos> position : positions.entrySet()) {
            BlockPos pos;
            if (!position.getKey().getDimension().equals((Object)dimension) || (pos = position.getValue()).func_177958_n() < startPos.func_177958_n() - xRange || pos.func_177958_n() > startPos.func_177958_n() + xRange || pos.func_177956_o() < startPos.func_177956_o() - yRange || pos.func_177956_o() > startPos.func_177956_o() + yRange || pos.func_177952_p() < startPos.func_177952_p() - zRange || pos.func_177952_p() > startPos.func_177952_p() + zRange) continue;
            positionsInRange.add(pos);
        }
        return positionsInRange;
    }

    @SubscribeEvent
    public void serverStopping(FMLServerStoppedEvent event) {
        PedestalRegistry.clearPositions();
    }

    private static class LocationKey {
        private final ResourceLocation dimension;
        private final long location;

        LocationKey(ResourceLocation dimension, long location) {
            this.dimension = dimension;
            this.location = location;
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.location);
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationKey)) {
                return false;
            }
            LocationKey key2 = (LocationKey)o;
            return this.getDimension().equals((Object)key2.getDimension()) && this.getLocation() == key2.getLocation();
        }

        ResourceLocation getDimension() {
            return this.dimension;
        }

        public long getLocation() {
            return this.location;
        }
    }
}

