/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.common.IPlantable;
import xreliquary.items.util.FilteredBigItemStack;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.reference.Settings;

public class HarvestRodItemStackHandler
extends FilteredItemStackHandler {
    public static final int BONEMEAL_SLOT = 0;

    private static List<FilteredItemStackHandler.RemovableStack> getDefaultStacks() {
        ArrayList<FilteredItemStackHandler.RemovableStack> stacks = new ArrayList<FilteredItemStackHandler.RemovableStack>();
        stacks.add(new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(Items.field_196106_bc, (int)((Integer)Settings.COMMON.items.harvestRod.boneMealLimit.get()), (int)((Integer)Settings.COMMON.items.harvestRod.boneMealWorth.get())), false));
        return stacks;
    }

    public HarvestRodItemStackHandler() {
        super(HarvestRodItemStackHandler.getDefaultStacks());
        this.setDynamicSlotNumber();
    }

    @Override
    protected int getDynamicStackLimit() {
        return (Integer)Settings.COMMON.items.harvestRod.maxCapacityPerPlantable.get();
    }

    @Override
    protected boolean isValidForBigStackSlot(ItemStack stack, int bigStackSlot) {
        if (bigStackSlot == 0) {
            return stack.func_77973_b() == Items.field_196106_bc;
        }
        return super.isValidForBigStackSlot(stack, bigStackSlot);
    }

    @Override
    protected boolean isValidForDynamicStack(ItemStack stack) {
        return this.isPlantable(stack);
    }

    private boolean isPlantable(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof IPlantable || item instanceof BlockNamedItem && ((BlockNamedItem)item).func_179223_d() instanceof IGrowable;
    }

    public int getBoneMealCount() {
        return this.getTotalAmount(0);
    }

    public void setBoneMealCount(int boneMealCount) {
        this.setTotalAmount(0, boneMealCount);
    }

    public Optional<PlantableSlotInserted> insertPlantable(ItemStack stack) {
        for (int slot = 1; slot < this.getSlots(); ++slot) {
            ItemStack result = this.insertItem(slot, stack, false);
            if (result.func_190916_E() >= stack.func_190916_E()) continue;
            return Optional.of(new PlantableSlotInserted(this.getBigStackSlot(slot), stack.func_190916_E() - result.func_190916_E()));
        }
        return Optional.empty();
    }

    public int getCountPlantable() {
        return this.getBigStackSlots() - 1;
    }

    public static class PlantableSlotInserted {
        private final int slot;
        private final int countInserted;

        public PlantableSlotInserted(int slot, int countInserted) {
            this.slot = slot;
            this.countInserted = countInserted;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getCountInserted() {
            return this.countInserted;
        }
    }
}

