/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteredBigItemStack
implements INBTSerializable<CompoundNBT> {
    private ItemStack filter;
    private int amount;
    private final int amountLimit;
    private final int unitWorth;
    private ItemStack outputStack = ItemStack.field_190927_a;
    private ItemStack inputStack = ItemStack.field_190927_a;

    public FilteredBigItemStack(Item filter, int amountLimit, int unitWorth) {
        this(new ItemStack((IItemProvider)filter), amountLimit, unitWorth);
    }

    FilteredBigItemStack(int amountLimit) {
        this(amountLimit, 1);
    }

    FilteredBigItemStack(ItemStack filter, int amountLimit) {
        this(filter, amountLimit, 1);
    }

    private FilteredBigItemStack(ItemStack filter, int amountLimit, int unitWorth) {
        this(amountLimit, unitWorth);
        this.filter = filter.func_77946_l();
        this.filter.func_190920_e(1);
    }

    private FilteredBigItemStack(int amountLimit, int unitWorth) {
        this.amountLimit = amountLimit;
        this.unitWorth = unitWorth;
    }

    public ItemStack getFilterStack() {
        return this.filter;
    }

    public ItemStack getFullStack() {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.filter, (int)this.amount);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        ret.func_74768_a("amount", this.amount);
        return ret;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("filter"));
        this.setAmount(nbt.func_74762_e("amount"));
    }

    void setAmount(int newAmount) {
        this.amount = newAmount;
        this.outputStack = this.filter.func_77946_l();
        this.outputStack.func_190920_e(Math.min(this.amount, this.filter.func_77976_d()));
        int remainingSpace = this.amountLimit - this.amount;
        if (remainingSpace < this.filter.func_77976_d()) {
            this.inputStack = this.filter.func_77946_l();
            this.inputStack.func_190920_e(this.filter.func_77976_d() - remainingSpace);
        } else {
            this.inputStack = ItemStack.field_190927_a;
        }
    }

    ItemStack insertItem(ItemStack stack, boolean simulate, boolean inputSlot) {
        boolean reachedLimit;
        ItemStack existing = inputSlot ? this.getInputStack() : this.getOutputStack();
        int limit = this.filter.func_77976_d() - existing.func_190916_E();
        int remainingTotal = this.worthToUnits(this.amountLimit - this.amount);
        if ((limit = Math.min(limit, remainingTotal)) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            this.setAmount(this.amount + this.unitsToWorth(reachedLimit ? limit : stack.func_190916_E()));
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    ItemStack getOutputStack() {
        return this.outputStack;
    }

    ItemStack getInputStack() {
        return this.inputStack;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    void markDirty() {
        int inputCount = this.inputStack.func_190926_b() ? 0 : this.inputStack.func_190916_E();
        int remainingUnits = this.worthToUnits(this.amountLimit - this.amount);
        int outputCount = this.outputStack.func_190926_b() ? 0 : this.outputStack.func_190916_E();
        int amountUnits = this.worthToUnits(this.amount);
        if (inputCount != Math.max(this.filter.func_77976_d() - remainingUnits, 0)) {
            this.setAmount(this.amount + this.unitWorth * (inputCount - Math.max(this.filter.func_77976_d() - remainingUnits, 0)));
        }
        if (outputCount != Math.min(amountUnits, this.filter.func_77976_d())) {
            this.setAmount(this.amount + this.unitsToWorth(outputCount - Math.min(amountUnits, this.filter.func_77976_d())));
        }
    }

    private int worthToUnits(int valueWorth) {
        return valueWorth / this.unitWorth;
    }

    private int unitsToWorth(int valueUnits) {
        return this.unitWorth * valueUnits;
    }

    boolean isValid(ItemStack stack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.filter, (ItemStack)stack);
    }

    void setInputStack(ItemStack inputStack) {
        this.inputStack = inputStack;
    }

    void setOutputStack(ItemStack outputStack) {
        this.outputStack = outputStack;
    }

    public int getAmount() {
        return this.amount;
    }
}

