/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.items.ItemBase;
import xreliquary.util.InventoryHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;
import xreliquary.util.RegistryHelper;

public abstract class ToggleableItem
extends ItemBase {
    protected static final String QUANTITY_TAG = "Quantity";
    protected static final String ITEM_NAME_TAG = "Name";
    private static final String ENABLED_TAG = "enabled";
    private static final String COOLDOWN_TAG = "coolDown";
    private static final String ITEMS_TAG = "Items";

    protected ToggleableItem(Item.Properties properties, Supplier<Boolean> isDisabled) {
        super(properties, isDisabled);
    }

    protected ToggleableItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnabled(stack);
    }

    protected void setCooldown(ItemStack stack, World world, int cooldown) {
        NBTHelper.putLong(COOLDOWN_TAG, stack, world.func_82737_E() + (long)cooldown);
    }

    protected boolean isInCooldown(ItemStack stack, World world) {
        return NBTHelper.getLong(COOLDOWN_TAG, stack) > world.func_82737_E();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_225608_bj_()) {
            this.toggleEnabled(stack);
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77962_s() != newStack.func_77962_s();
    }

    public boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean(ENABLED_TAG, stack);
    }

    void toggleEnabled(ItemStack stack) {
        NBTHelper.putBoolean(ENABLED_TAG, stack, !NBTHelper.getBoolean(ENABLED_TAG, stack));
    }

    protected void consumeAndCharge(PlayerEntity player, int freeCapacity, int chargePerItem, Item item, int maxCount, IntConsumer addCharge) {
        this.consumeAndCharge(player, freeCapacity, chargePerItem, (ItemStack ist) -> ist.func_77973_b() == item, maxCount, addCharge);
    }

    protected void consumeAndCharge(PlayerEntity player, int freeCapacity, int chargePerItem, Predicate<ItemStack> itemMatches, int maxCount, IntConsumer addCharge) {
        int maximumToConsume = Math.min(freeCapacity / chargePerItem, maxCount);
        if (maximumToConsume == 0) {
            return;
        }
        int chargeToAdd = InventoryHelper.consumeItemStack(itemMatches, player, maximumToConsume).func_190916_E() * chargePerItem;
        if (chargeToAdd > 0) {
            addCharge.accept(chargeToAdd);
        }
    }

    protected void addItemToInternalStorage(ItemStack stack, Item item, int chargeToAdd) {
        this.addItemToInternalStorage(stack, RegistryHelper.getItemRegistryName(item), chargeToAdd);
    }

    protected void addItemToInternalStorage(ItemStack stack, String itemRegistryName, int chargeToAdd) {
        AtomicBoolean found = new AtomicBoolean(false);
        this.updateItems(stack, tag -> {
            String itemName = tag.func_74779_i(ITEM_NAME_TAG);
            if (itemName.equals(itemRegistryName)) {
                int quantity = tag.func_74762_e(QUANTITY_TAG);
                tag.func_74768_a(QUANTITY_TAG, quantity + chargeToAdd);
                found.set(true);
            }
        }, found::get, list -> {
            if (!found.get()) {
                CompoundNBT newTagData = new CompoundNBT();
                newTagData.func_74778_a(ITEM_NAME_TAG, itemRegistryName);
                newTagData.func_74768_a(QUANTITY_TAG, chargeToAdd);
                list.add((Object)newTagData);
            }
        });
    }

    private void updateItems(ItemStack stack, Consumer<CompoundNBT> actOnItemTag, BooleanSupplier shouldExit, Consumer<ListNBT> actOnListAfter) {
        CompoundNBT tag = NBTHelper.getTag(stack);
        this.iterateItems(tag, actOnItemTag, shouldExit, itemList -> {
            tag.func_218657_a(ITEMS_TAG, (INBT)itemList);
            actOnListAfter.accept((ListNBT)itemList);
        });
        stack.func_77982_d(tag);
    }

    protected void iterateItems(ItemStack stack, Consumer<CompoundNBT> actOnItemTag, BooleanSupplier shouldExit) {
        this.iterateItems(NBTHelper.getTag(stack), actOnItemTag, shouldExit, list -> {});
    }

    private void iterateItems(CompoundNBT tagCompound, Consumer<CompoundNBT> actOnItemTag, BooleanSupplier shouldExit, Consumer<ListNBT> actOnListAfter) {
        ListNBT tagList = tagCompound.func_150295_c(ITEMS_TAG, 10);
        for (int i = 0; i < tagList.size(); ++i) {
            actOnItemTag.accept(tagList.func_150305_b(i));
            if (shouldExit.getAsBoolean()) break;
        }
        actOnListAfter.accept(tagList);
    }

    public boolean removeItemFromInternalStorage(ItemStack stack, ForgeRegistryEntry<?> registryEntry, int quantityToRemove, boolean simulate, PlayerEntity player) {
        if (player.func_184812_l_()) {
            return true;
        }
        AtomicBoolean updated = new AtomicBoolean(false);
        this.updateItems(stack, tag -> {
            String itemName = tag.func_74779_i(ITEM_NAME_TAG);
            if (itemName.equals(RegistryHelper.getRegistryName(registryEntry).toString())) {
                int originalQuantity = tag.func_74762_e(QUANTITY_TAG);
                if (originalQuantity - quantityToRemove < 0) {
                    updated.set(false);
                    return;
                }
                if (!simulate) {
                    tag.func_74768_a(QUANTITY_TAG, originalQuantity - quantityToRemove);
                }
                updated.set(true);
            }
        }, updated::get, list -> {});
        return updated.get();
    }

    public int getInternalStorageItemCount(ItemStack stack, Item item) {
        return this.getInternalStorageItemCount(stack, RegistryHelper.getItemRegistryName(item));
    }

    public int getInternalStorageItemCount(ItemStack stack, String itemRegistryName) {
        AtomicInteger ret = new AtomicInteger(-1);
        this.iterateItems(stack, tag -> {
            if (tag.func_74779_i(ITEM_NAME_TAG).equals(itemRegistryName)) {
                ret.set(tag.func_74762_e(QUANTITY_TAG));
            }
        }, () -> ret.get() >= 0);
        return Math.max(ret.get(), 0);
    }

    protected boolean hasSpaceForItem(ItemStack stack, Item item, int quantityLimit) {
        return this.getInternalStorageItemCount(stack, item) < quantityLimit;
    }
}

