/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.fluid.FluidHandlerEmperorChalice;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;

public class EmperorChaliceItem
extends ToggleableItem {
    public EmperorChaliceItem() {
        super(new Item.Properties().func_200917_a(1).setNoRepair().func_208103_a(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.addListener(this::onBlockRightClick);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerEmperorChalice(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        int multiplier = (Integer)Settings.COMMON.items.emperorChalice.hungerSatiationMultiplier.get();
        player.func_71024_bL().func_75122_a(1, (float)multiplier / 2.0f);
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return stack;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack emperorChalice = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(emperorChalice);
        BlockRayTraceResult result = EmperorChaliceItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(isInDrainMode ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (result == null) {
            if (!this.isEnabled(emperorChalice)) {
                player.func_184598_c(hand);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)emperorChalice);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (!world.func_175660_a(player, result.func_216350_a()) || !player.func_175151_a(result.func_216350_a(), result.func_216354_b(), emperorChalice)) {
                return new ActionResult(ActionResultType.FAIL, (Object)emperorChalice);
            }
            if (emperorChalice.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> {
                if (!this.isEnabled(emperorChalice)) {
                    return this.placeWater(world, player, hand, (IFluidHandlerItem)fluidHandler, result);
                }
                return FluidUtil.tryPickUpFluid((ItemStack)emperorChalice, (PlayerEntity)player, (World)world, (BlockPos)result.func_216350_a(), (Direction)result.func_216354_b()).isSuccess();
            }).orElse(false).booleanValue()) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)emperorChalice);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)emperorChalice);
    }

    private boolean placeWater(World world, PlayerEntity player, Hand hand, IFluidHandlerItem fluidHandler, BlockRayTraceResult result) {
        if (FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a(), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000))) {
            return true;
        }
        return FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a().func_177972_a(result.func_216354_b()), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000));
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock evt) {
        World world;
        BlockState state;
        if (evt.getItemStack().func_77973_b() == this && (state = (world = evt.getWorld()).func_180495_p(evt.getPos())).func_177230_c() == Blocks.field_150383_bp) {
            if (!this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) == 0) {
                this.fillCauldron(evt, world, state);
            } else if (this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) == 3) {
                this.emptyCauldron(evt, world, state);
            }
        }
    }

    private void emptyCauldron(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state) {
        int level = 0;
        this.setCauldronLevel(evt, world, state, level);
    }

    private void fillCauldron(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state) {
        this.setCauldronLevel(evt, world, state, 3);
    }

    private void setCauldronLevel(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state, int level) {
        ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, evt.getPos(), state, level);
        evt.setUseItem(Event.Result.DENY);
        evt.setCanceled(true);
        evt.setCancellationResult(ActionResultType.SUCCESS);
    }
}

