/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class ExorcismShotEntity
extends ShotEntityBase {
    public ExorcismShotEntity(EntityType<ExorcismShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public ExorcismShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.EXORCISM_SHOT, world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            double gauss = this.gaussian(1.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), gauss, gauss, 0.0);
        }
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), this.posGauss(1.0), this.posGauss(1.0), 0.0);
        }
    }

    private boolean isUndead(LivingEntity e) {
        return e.func_70668_bt() == CreatureAttribute.field_223223_b_;
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        return (this.isUndead(e) ? 9 + this.d3() : 0) + 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.EXORCISM;
    }
}

