/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import xreliquary.crafting.FragmentToSpawnEggRecipe;

public class SpawnEggRecipeBuilder {
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    private SpawnEggRecipeBuilder() {
    }

    public static SpawnEggRecipeBuilder spawnEggRecipe() {
        return new SpawnEggRecipeBuilder();
    }

    public SpawnEggRecipeBuilder addIngredient(IItemProvider itemProvider) {
        this.ingredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
        return this;
    }

    public SpawnEggRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.ingredients, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + id.func_110623_a())));
    }

    public static class Result
    implements IFinishedRecipe {
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final ResourceLocation id;

        public Result(ResourceLocation id, List<Ingredient> ingredients, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.ingredients = ingredients;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", "minecraft:chicken_spawn_egg");
            json.add("result", (JsonElement)jsonobject);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return FragmentToSpawnEggRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

