/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import java.util.Optional;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.init.ModItems;
import xreliquary.items.MobCharmDefinition;
import xreliquary.items.MobCharmRegistry;
import xreliquary.reference.Settings;

public class MobCharmRepairRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<MobCharmRepairRecipe> SERIALIZER = new SpecialRecipeSerializer(MobCharmRepairRecipe::new);
    private static final int PER_FRAGMENT_MULTIPLIER = 6;

    public MobCharmRepairRecipe(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack ingredient = ItemStack.field_190927_a;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (currentStack.func_77973_b() == ModItems.MOB_CHARM.get()) {
                if (!mobCharm.func_190926_b()) {
                    return false;
                }
                mobCharm = currentStack;
                continue;
            }
            if (ingredient.func_190926_b()) {
                ingredient = currentStack;
            } else if (!ingredient.func_77969_a(currentStack)) {
                return false;
            }
            ++numberIngredients;
        }
        if (mobCharm.func_190926_b()) {
            return false;
        }
        ItemStack finalIngredient = ingredient;
        Optional<MobCharmDefinition> cd = MobCharmRegistry.getCharmDefinitionFor(mobCharm);
        if (!cd.isPresent()) {
            return false;
        }
        MobCharmDefinition charmDefinition = cd.get();
        int repairMultiplier = charmDefinition.isDynamicallyCreated() ? 6 : 1;
        int durabilityRepaired = (Integer)Settings.COMMON.items.mobCharm.dropDurabilityRepair.get() * repairMultiplier;
        return mobCharm.func_77952_i() >= durabilityRepaired * (numberIngredients - 1) && charmDefinition.isRepairItem(finalIngredient);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack ingredient = ItemStack.field_190927_a;
        int numberIngredients = 0;
        ItemStack mobCharm = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack currentStack = inv.func_70301_a(i);
            if (currentStack.func_190926_b()) continue;
            if (currentStack.func_77973_b() == ModItems.MOB_CHARM.get()) {
                mobCharm = currentStack;
                continue;
            }
            if (ingredient.func_190926_b()) {
                ingredient = currentStack;
            }
            ++numberIngredients;
        }
        ItemStack resultingMobCharm = mobCharm.func_77946_l();
        resultingMobCharm.func_196085_b(Math.max(resultingMobCharm.func_77952_i() - (Integer)Settings.COMMON.items.mobCharm.dropDurabilityRepair.get() * numberIngredients, 0));
        return resultingMobCharm;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

