/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.entities.LyssaBobberEntity;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.reference.Settings;

public class InterdictionTorchBlock
extends TorchBlock {
    protected static final int TICK_RATE = 1;

    public InterdictionTorchBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_235838_a_(value -> 15).func_200944_c().func_200947_a(SoundType.field_185848_a).func_200942_a(), (IParticleData)ParticleTypes.field_197631_x);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        super.func_225534_a_(state, world, pos, random);
        world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        if (world.field_72995_K) {
            return;
        }
        int radius = (Integer)Settings.COMMON.blocks.interdictionTorch.pushRadius.get();
        List entities = world.func_175647_a(Entity.class, new AxisAlignedBB(pos).func_186662_g((double)radius), e -> e instanceof MobEntity || e instanceof ProjectileEntity);
        for (Entity entity : entities) {
            double distance;
            if (entity instanceof PlayerEntity || entity instanceof ShotEntityBase || entity instanceof FishingBobberEntity || entity instanceof LyssaBobberEntity || !((distance = Math.sqrt(entity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) < (double)radius) || distance == 0.0 || this.isBlacklistedEntity(entity)) continue;
            if (distance < 1.0) {
                distance = 1.0;
            }
            double knockbackMultiplier = 1.0 + 1.0 / distance;
            double reductionCoefficient = 0.04;
            Vector3d angleOfAttack = entity.func_213303_ch().func_72441_c(-((double)pos.func_177958_n() + 0.5), (double)(-pos.func_177956_o()), -((double)pos.func_177952_p() + 0.5));
            double xForce = angleOfAttack.field_72450_a * knockbackMultiplier * reductionCoefficient;
            double yForce = angleOfAttack.field_72448_b * knockbackMultiplier * reductionCoefficient;
            double zForce = angleOfAttack.field_72449_c * knockbackMultiplier * reductionCoefficient;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(xForce, yForce, zForce));
        }
    }

    private boolean isBlacklistedEntity(Entity entity) {
        if (ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()) == null) {
            return false;
        }
        String entityName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()).toString();
        return this.isBlacklistedLivingEntity(entity, entityName) || (Boolean)Settings.COMMON.blocks.interdictionTorch.canPushProjectiles.get() != false && this.isBlacklistedProjectile(entity, entityName);
    }

    private boolean isBlacklistedProjectile(Entity entity, String entityName) {
        return entity instanceof ProjectileEntity && ((List)Settings.COMMON.blocks.interdictionTorch.pushableProjectilesBlacklist.get()).contains(entityName);
    }

    private boolean isBlacklistedLivingEntity(Entity entity, String entityName) {
        return entity instanceof MobEntity && ((List)Settings.COMMON.blocks.interdictionTorch.pushableEntitiesBlacklist.get()).contains(entityName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        double xOffset = (float)pos.func_177958_n() + 0.5f;
        double yOffset = (float)pos.func_177956_o() + 0.7f;
        double zOffset = (float)pos.func_177952_p() + 0.5f;
        world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
    }
}

