/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import mc.craig.software.regen.util.RegenUtil;

public class SkinApi {
    private static final String USER_AGENT = "Regeneration MC Mod/1.0";
    private static final String URL = "https://api.mineskin.org";
    private static final String API_ENDPOINT = "https://mc.craig.software/api/skin/random-skins";

    public static ArrayList<String> getSkinsFromPage(int page) throws IOException {
        ArrayList<String> foundSkins = new ArrayList<String>();
        JsonElement json = SkinApi.getApiData("https://api.mineskin.org/get/list/" + page);
        if (json.isJsonArray()) {
            for (JsonElement jsonElement : json.getAsJsonArray()) {
                JsonElement t = jsonElement.getAsJsonObject().get("url");
                foundSkins.add(t.getAsString());
            }
        }
        return foundSkins;
    }

    public static ArrayList<JsonElement> interalApiSkins() throws IOException {
        ArrayList<JsonElement> foundSkins = new ArrayList<JsonElement>();
        JsonArray json = SkinApi.getApiData(API_ENDPOINT).getAsJsonArray();
        for (JsonElement jsonElement : json) {
            JsonObject jsonData = jsonElement.getAsJsonObject();
            foundSkins.add((JsonElement)jsonData);
        }
        return foundSkins;
    }

    public static boolean isUserValid(UUID uuid) throws IOException {
        JsonElement response = SkinApi.getApiData("https://api.mineskin.org/validate/uuid/" + uuid);
        if (response.isJsonObject() && response.getAsJsonObject().has("valid") && response.getAsJsonObject().has("uuid")) {
            return response.getAsJsonObject().get("valid").getAsBoolean();
        }
        return false;
    }

    public static ArrayList<String> searchSkins(String searchTerm) throws IOException {
        JsonElement response = SkinApi.getApiData("https://api.mineskin.org/get/list?filter=" + searchTerm);
        System.out.println(response);
        ArrayList<String> foundSkins = new ArrayList<String>();
        JsonArray skinData = response.getAsJsonObject().get("skins").getAsJsonArray();
        for (int skinIndex = skinData.size() - 1; skinIndex >= 0; --skinIndex) {
            JsonElement skin = skinData.get(skinIndex).getAsJsonObject().get("url");
            foundSkins.add(skin.getAsString());
        }
        return foundSkins;
    }

    public static JsonElement getApiData(String url) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        if (connection.getResponseCode() == 200) {
            String line;
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return (JsonElement)RegenUtil.GSON.fromJson(stringBuilder.toString(), JsonElement.class);
        }
        throw new IOException("Failed to connect to API. Response code: " + connection.getResponseCode());
    }
}

