/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import mc.craig.software.regen.common.item.HandItem;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.util.Platform;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.FileUtils;

public class RegenUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static class_6862<class_2248> BANNED_BLOCKS = RegenUtil.makeBlock("weeping_angels", "angel_proof");
    public static class_6862<class_2248> ARS = RegenUtil.makeBlock("tardis", "ars");
    public static class_6862<class_1792> TIMELORD_CURRENCY = RegenUtil.makeItem("regen", "timelord_currency");
    public static class_6862<class_2248> ZINC = RegenUtil.makeBlock("forge", "ores/zinc");
    public static class_6862<class_1792> ZINC_INGOT = RegenUtil.makeItem("forge", "ingots/zinc");
    public static class_6862<class_1959> TIMELORD_SETTLEMENT = RegenUtil.makeBiome("has_structure/timelord_settlement");
    public static class_6862<class_1959> IS_OVERWORLD = RegenUtil.makeBiome("overworld_ore");
    public static class_6862<class_1291> POST_REGEN_POTIONS = RegenUtil.makeMobEffects("post_regen");
    public static class_5819 RAND = class_5819.method_43047();
    public static String[] USERNAMES = new String[0];

    public static class_6862<class_2248> makeBlock(String domain, String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(domain, path));
    }

    private static class_6862<class_1959> makeBiome(String name) {
        return class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("regen", name));
    }

    private static class_6862<class_1291> makeMobEffects(String name) {
        return class_6862.method_40092((class_5321)class_7924.field_41208, (class_2960)new class_2960("regen", name));
    }

    public static class_6862<class_1792> makeItem(String domain, String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(domain, path));
    }

    public static double round(float value, int scale) {
        return (double)Math.round((double)value * Math.pow(10.0, scale)) / Math.pow(10.0, scale);
    }

    public static boolean shouldGiveCouncilAdvancement(class_3222 serverPlayerEntity) {
        class_1304[] equipmentSlotTypes;
        for (class_1304 equipmentSlotType : equipmentSlotTypes = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
            if (class_7923.field_41178.method_10221((Object)serverPlayerEntity.method_6118(equipmentSlotType).method_7909()).method_12832().contains("robes")) continue;
            return false;
        }
        return true;
    }

    public static void setupNames() {
        if (USERNAMES.length == 0) {
            class_2960 resourceLocation = new class_2960("regen", "names.json");
            Platform.getServer().method_34864().method_14486(resourceLocation).ifPresent(resource -> {
                try {
                    InputStream stream = resource.method_14482();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    reader.close();
                    stream.close();
                    USERNAMES = (String[])GSON.fromJson(sb.toString(), String[].class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static float randFloat(float min, float max) {
        return RAND.method_43057() * (max - min) + min;
    }

    public static boolean doesHaveInternet() {
        try {
            Socket socket = new Socket("www.google.com", 80);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] fileToBytes(File file) {
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String colorToHex(Color color) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(color.getRGB() & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.insert(0, "0");
        }
        return "#" + hex;
    }

    public static void spawnHandIfPossible(class_1309 livingEntity, class_1799 itemStack) {
        if (itemStack.method_7909() instanceof class_1766 || itemStack.method_7909() instanceof class_1829) {
            RegenerationData.get(livingEntity).ifPresent(data -> {
                if (data.regenState() == RegenStates.POST && livingEntity.method_5715() & data.handState() == IRegen.Hand.NOT_CUT) {
                    HandItem.createHand(livingEntity);
                }
            });
        }
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

