/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.util;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.common.traits.trait.TraitBase;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

public class RTextHelper {
    public static class_5250 createTextComponentWithTip(String text, String tooltipText) {
        class_5250 textComponent = class_2561.method_43470((String)("[" + text + "]"));
        textComponent.method_27694(style -> style.method_27706(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)tooltipText))).method_10958(new class_2558(class_2558.class_2559.field_21462, tooltipText)));
        return textComponent;
    }

    public static class_5250 getPlayerTextObject(class_3218 world, UUID id) {
        GameProfile profileByUUID = (GameProfile)world.method_8503().method_3793().method_14512(id).get();
        String playerName = "OFFLINE Player";
        if (profileByUUID != null) {
            playerName = profileByUUID.getName();
        }
        return RTextHelper.createTextComponentWithTip(playerName, id.toString());
    }

    public static class_5250 getEntityTextObject(class_3218 world, UUID id) {
        if (world == null) {
            throw new IllegalArgumentException("world cannot be null");
        }
        class_1297 entity = world.method_14190(id);
        String entityName = entity != null ? entity.method_5477().getString() : "Null Entity";
        return RTextHelper.createTextComponentWithTip(entityName, id.toString());
    }

    public static String formatTraitName(TraitBase trait) {
        if (trait == null) {
            return "null";
        }
        String original = TraitRegistry.TRAITS_REGISTRY.getKey(trait).method_12832().trim().replace(" ", "").replace("_", " ");
        return Arrays.stream(original.split(" +")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
    }

    public static class_5250 getTraitTextObject(TraitBase trait) {
        if (trait != null) {
            String formattedName = RTextHelper.formatTraitName(trait);
            return RTextHelper.createTextComponentWithTip(formattedName, TraitRegistry.TRAITS_REGISTRY.getKey(trait).toString());
        }
        return RTextHelper.createTextComponentWithTip("Null Trait", "Null");
    }
}

