/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.util;

import java.util.stream.Stream;
import mc.craig.software.regen.common.advancement.TriggerManager;
import mc.craig.software.regen.common.objects.RBlocks;
import mc.craig.software.regen.config.RegenConfig;
import mc.craig.software.regen.network.messages.ModelMessage;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.RegenUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class PlayerUtil {
    public static boolean isPlayerAboveZeroGrid(class_1309 playerEntity) {
        class_2338 livingPos = playerEntity.method_24515().method_10074();
        class_238 grid = new class_238(livingPos.method_10095().method_10067(), livingPos.method_10072().method_10078());
        Stream blockPositions = class_2338.method_20437((class_2338)new class_2338((int)grid.field_1320, (int)grid.field_1325, (int)grid.field_1324), (class_2338)new class_2338((int)grid.field_1323, (int)grid.field_1322, (int)grid.field_1321));
        boolean allZeroRoomBlocks = blockPositions.allMatch(pos -> {
            class_2680 state = playerEntity.method_37908().method_8320(pos);
            return state.method_26204() == RBlocks.ZERO_ROOM_FULL.get() || state.method_26204() == RBlocks.ZERO_ROUNDEL.get();
        });
        if (allZeroRoomBlocks && playerEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)playerEntity;
            TriggerManager.ZERO_ROOM.trigger(serverPlayer);
        }
        return allZeroRoomBlocks;
    }

    public static void handleZeroGrid(class_1309 playerEntity) {
        class_6885.class_6888 mobEffects = (class_6885.class_6888)class_7923.field_41174.method_40266(RegenUtil.POST_REGEN_POTIONS).get();
        for (class_6880 mobEffect : mobEffects) {
            class_1291 effect = (class_1291)mobEffect.comp_349();
            if (!playerEntity.method_6059(effect)) continue;
            playerEntity.method_6016(effect);
        }
    }

    public static void globalMessage(class_2561 body, MinecraftServer server) {
        if (server == null) {
            return;
        }
        class_3324 playerList = server.method_3760();
        for (class_3222 player : playerList.method_14571()) {
            player.method_43496(body);
        }
    }

    public static void sendMessage(class_1309 livingEntity, String message, boolean hotBar) {
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        if (!player.method_37908().field_9236) {
            player.method_7353((class_2561)class_2561.method_43471((String)message), hotBar);
        }
    }

    public static void sendMessage(class_1309 livingEntity, class_5250 translation, boolean hotBar) {
        if (!(livingEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)livingEntity;
        if (!player.method_37908().field_9236) {
            player.method_7353((class_2561)translation, hotBar);
        }
    }

    public static void applyPotionIfAbsent(class_1309 player, class_1291 potion, int length, int amplifier, boolean ambient, boolean showParticles) {
        if (potion == null) {
            return;
        }
        if (player.method_6112(potion) == null) {
            player.method_6092(new class_1293(potion, length, amplifier, ambient, showParticles));
        }
    }

    public static class_238 getReach(class_2338 pos, int range) {
        return new class_238(pos.method_10086(range).method_10076(range).method_10088(range), pos.method_10087(range).method_10077(range).method_10089(range));
    }

    public static void explodeKnockback(class_1297 exploder, class_1937 world, class_2338 pos, double knockback, int range) {
        world.method_8335(exploder, PlayerUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof class_1309) {
                class_1309 victim = (class_1309)entity;
                if (exploder.method_5805()) {
                    if (entity instanceof class_1657 && !((Boolean)RegenConfig.COMMON.regenerationKnocksbackPlayers.get()).booleanValue() || !victim.method_5822()) {
                        return;
                    }
                    float densMod = class_1927.method_17752((class_243)entity.method_19538(), (class_1297)entity);
                    int xr = (int)(-(victim.method_23317() - exploder.method_23317()));
                    int zr = (int)(-(victim.method_23321() - exploder.method_23321()));
                    victim.method_18799(victim.method_18798().method_18805(knockback * (double)densMod, (double)xr, (double)zr));
                }
            }
        });
    }

    public static void regenerationExplosion(class_1309 player) {
        PlayerUtil.explodeKnockback((class_1297)player, player.method_37908(), player.method_24515(), (Double)RegenConfig.COMMON.regenerativeKnockback.get(), (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        PlayerUtil.explodeKill((class_1297)player, player.method_37908(), player.method_24515(), (Integer)RegenConfig.COMMON.regenerativeKillRange.get());
    }

    public static void explodeKill(class_1297 exploder, class_1937 world, class_2338 pos, int range) {
        world.method_8335(exploder, PlayerUtil.getReach(pos, range)).forEach(entity -> {
            if (entity instanceof class_1314 && entity.method_5822() || entity instanceof class_1657) {
                entity.method_5643(new class_1282(RegenDamageTypes.getHolder(world, RegenDamageTypes.REGEN_DMG_ENERGY_EXPLOSION)), 3.5f);
            }
        });
    }

    public static void updateModel(SkinType choices) {
        new ModelMessage(choices).send();
    }

    public static boolean isInHand(class_1268 hand, class_1309 holder, class_1792 item) {
        class_1799 heldItem = holder.method_5998(hand);
        return heldItem.method_7909() == item;
    }

    public static boolean isInMainHand(class_1309 holder, class_1792 item) {
        return PlayerUtil.isInHand(class_1268.field_5808, holder, item);
    }

    public static boolean isInOffHand(class_1309 holder, class_1792 item) {
        return PlayerUtil.isInHand(class_1268.field_5810, holder, item);
    }

    public static boolean isInEitherHand(class_1309 holder, class_1792 item) {
        return PlayerUtil.isInMainHand(holder, item) || PlayerUtil.isInOffHand(holder, item);
    }

    public static boolean isInOneHand(class_1309 holder, class_1792 item) {
        boolean mainHand = PlayerUtil.isInMainHand(holder, item) && !PlayerUtil.isInOffHand(holder, item);
        boolean offHand = PlayerUtil.isInOffHand(holder, item) && !PlayerUtil.isInMainHand(holder, item);
        return mainHand || offHand;
    }

    public static enum SkinType implements RegenUtil.IEnum<SkinType>
    {
        ALEX,
        STEVE,
        EITHER;


        public boolean isAlex() {
            if (this == EITHER) {
                return RegenUtil.RAND.method_43056();
            }
            return this == ALEX;
        }
    }
}

