/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.network.fabric;

import mc.craig.software.regen.Regeneration;
import mc.craig.software.regen.network.MessageC2S;
import mc.craig.software.regen.network.MessageS2C;
import mc.craig.software.regen.network.MessageType;
import mc.craig.software.regen.network.NetworkManager;
import mc.craig.software.regen.util.Platform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkManagerImpl
extends NetworkManager {
    public NetworkManagerImpl(class_2960 channelName) {
        super(channelName);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)channelName, (server, player, handler, buf, responseSender) -> {
            String msgId = buf.method_19772();
            if (!this.toServer.containsKey(msgId)) {
                Regeneration.LOGGER.warn("Unknown message id received on server: " + msgId);
                return;
            }
            MessageType type = (MessageType)this.toServer.get(msgId);
            MessageC2S message = (MessageC2S)type.getDecoder().decode(buf);
            server.execute(() -> message.handle(() -> player));
        });
        if (Platform.isClient()) {
            this.registerClient();
        }
    }

    public static NetworkManager create(class_2960 channelName) {
        return new NetworkManagerImpl(channelName);
    }

    public static class_2596<?> spawnPacket(class_1297 livingEntity) {
        return new class_2604(livingEntity);
    }

    @Environment(value=EnvType.CLIENT)
    private void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channelName, (client, handler, buf, responseSender) -> {
            String msgId = buf.method_19772();
            if (!this.toClient.containsKey(msgId)) {
                Regeneration.LOGGER.warn("Unknown message id received on client: " + msgId);
                return;
            }
            MessageType type = (MessageType)this.toClient.get(msgId);
            MessageS2C message = (MessageS2C)type.getDecoder().decode(buf);
            client.execute(() -> message.handle(() -> null));
        });
    }

    @Override
    public void sendToServer(MessageC2S message) {
        if (!this.toServer.containsValue(message.getType())) {
            Regeneration.LOGGER.warn("Message type not registered: " + message.getType().getId());
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(message.getType().getId());
        message.toBytes(buf);
        ClientPlayNetworking.send((class_2960)this.channelName, (class_2540)buf);
    }

    @Override
    public void sendToPlayer(class_3222 player, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            Regeneration.LOGGER.warn("Message type not registered: " + message.getType().getId());
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(message.getType().getId());
        message.toBytes(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelName, (class_2540)buf);
    }
}

