/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.mixin;

import mc.craig.software.regen.client.animation.AnimationHandler;
import mc.craig.software.regen.client.visual.AnimationManipulation;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.regen.transitions.TransitionTypes;
import mc.craig.software.regen.util.AnimationUtil;
import mc.craig.software.regen.util.PlayerUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_572.class})
public class BipedBodyMixin {
    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void setupAnimPre(class_1309 livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        class_572 bipedModel = (class_572)this;
        bipedModel.field_3398.method_32088().forEach(class_630::method_41923);
        bipedModel.field_3391.method_32088().forEach(class_630::method_41923);
        bipedModel.field_27433.method_32088().forEach(class_630::method_41923);
        bipedModel.field_3401.method_32088().forEach(class_630::method_41923);
        bipedModel.field_3397.method_32088().forEach(class_630::method_41923);
        bipedModel.field_3392.method_32088().forEach(class_630::method_41923);
        RegenerationData.get(livingEntity).ifPresent(data -> {
            if (data.regenState() == RegenStates.REGENERATING && data.transitionType() == TransitionTypes.TRISTIS_IGNIS) {
                AnimationUtil.animate(bipedModel, data.getAnimationState(IRegen.RegenAnimation.REGEN), AnimationManipulation.REGEN, ageInTicks, 1.0f);
                AnimationHandler.correctPlayerModel(bipedModel);
                callbackInfo.cancel();
            }
            if (data.regenState() == RegenStates.REGENERATING && data.transitionType() == TransitionTypes.DRINK) {
                AnimationUtil.animate(bipedModel, data.getAnimationState(IRegen.RegenAnimation.REGEN), AnimationManipulation.MCGANN_REGEN, ageInTicks, 1.0f);
                AnimationHandler.correctPlayerModel(bipedModel);
                callbackInfo.cancel();
            }
            if (data.regenState() == RegenStates.REGENERATING && data.transitionType() == TransitionTypes.SNEEZE) {
                AnimationUtil.animate(bipedModel, data.getAnimationState(IRegen.RegenAnimation.REGEN), AnimationManipulation.REGEN_11_12, ageInTicks, 1.0f);
                AnimationHandler.correctPlayerModel(bipedModel);
                callbackInfo.cancel();
            }
        });
    }

    @Inject(at={@At(value="TAIL")}, cancellable=true, method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"})
    private void setupAnim(class_1309 livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        class_572 bipedModel = (class_572)this;
        AnimationHandler.setRotationAnglesCallback(bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        RegenerationData.get(livingEntity).ifPresent(iCap -> {
            if (iCap.regenState() == RegenStates.GRACE_CRIT) {
                bipedModel.field_27433.method_32088().forEach(class_630::method_41923);
                bipedModel.field_3401.method_32088().forEach(class_630::method_41923);
                AnimationUtil.animate(bipedModel, iCap.getAnimationState(IRegen.RegenAnimation.GRACE), AnimationManipulation.GRACE, ageInTicks, 1.0f);
                AnimationHandler.correctPlayerModel(bipedModel);
                callbackInfo.cancel();
            }
        });
        if (livingEntity.method_5864() == class_1299.field_6097 && livingEntity.method_6014() > 0 && (PlayerUtil.isInEitherHand(livingEntity, RItems.PISTOL.get()) || PlayerUtil.isInEitherHand(livingEntity, RItems.RIFLE.get()))) {
            bipedModel.field_27433.field_3654 = bipedModel.field_3398.field_3654;
            bipedModel.field_27433.field_3675 = bipedModel.field_3398.field_3675;
            bipedModel.field_27433.field_3674 = bipedModel.field_3398.field_3674;
            bipedModel.field_3401.field_3654 = bipedModel.field_3398.field_3654;
            bipedModel.field_3401.field_3675 = bipedModel.field_3398.field_3675;
            bipedModel.field_3401.field_3674 = bipedModel.field_3398.field_3674;
            float aimTicks = class_3532.method_15363((float)((float)livingEntity.method_6014() / 100.0f), (float)0.0f, (float)1.0f);
            bipedModel.field_27433.field_3654 += (float)Math.toRadians(-55.0f + aimTicks * -30.0f);
            bipedModel.field_27433.field_3675 += (float)Math.toRadians((-45.0f + aimTicks * -20.0f) * -1.0f);
            bipedModel.field_3401.field_3654 += (float)Math.toRadians(-42.0f + aimTicks * -48.0f);
            bipedModel.field_3401.field_3675 += (float)Math.toRadians((-15.0f + aimTicks * 5.0f) * -1.0f);
        }
    }
}

