/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.fabric.mixin;

import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.config.RegenConfig;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.constants.RMessages;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"knockback(DDD)V"}, cancellable=true)
    public void knockback(double strength, double x, double z, CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        RegenerationData.get(livingEntity).ifPresent(regenerationData -> {
            if (regenerationData.isTraitActive() && regenerationData.getCurrentTrait() == TraitRegistry.KNOCKBACK.get()) {
                ci.cancel();
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    private void hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        RegenerationData data = RegenerationData.get(livingEntity).get();
        if (source.method_49708(RegenDamageTypes.REGEN_DMG_KILLED)) {
            return;
        }
        if (data.isTraitActive() && (data.getCurrentTrait() == TraitRegistry.FIRE_RESISTANCE.get() && (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) || data.getCurrentTrait() == TraitRegistry.ARROW_DODGE.get() && source.method_49708(class_8111.field_42323))) {
            cir.setReturnValue((Object)false);
        }
        if (data.regenState() == RegenStates.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) || data.regenState() == RegenStates.REGENERATING && source.method_49708(class_8111.field_42331)) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"))
    private float modifyDamageAmount(float value) {
        class_1309 livingEntity = (class_1309)this;
        RegenerationData data = RegenerationData.get(livingEntity).get();
        if (data.regenState() == RegenStates.POST && value != 2.1474836E9f) {
            PlayerUtil.sendMessage(livingEntity, class_2561.method_43471((String)RMessages.POST_REDUCED_DAMAGE), true);
            return 1.5f;
        }
        return value;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    private void tick(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        RegenerationData.get(livingEntity).ifPresent(RegenerationData::tick);
    }
}

