/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.regen.acting;

import java.util.Iterator;
import java.util.UUID;
import mc.craig.software.regen.common.advancement.TriggerManager;
import mc.craig.software.regen.common.block.JarBlock;
import mc.craig.software.regen.common.blockentity.BioContainerBlockEntity;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.acting.Acting;
import mc.craig.software.regen.common.regen.transitions.WatcherTransition;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.config.RegenConfig;
import mc.craig.software.regen.network.messages.SFXMessage;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.RegenUtil;
import mc.craig.software.regen.util.constants.RMessages;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class CommonActing
implements Acting {
    public static final Acting INSTANCE = new CommonActing();
    private final UUID SLOWNESS_ID = UUID.fromString("f9aa2c36-f3f3-4d76-a148-86d6f2c87782");
    private final UUID MAX_HEALTH_ID = UUID.fromString("5d6f0ba2-1286-46fc-b896-461c5cfd99cc");
    private final double HEART_REDUCTION = 0.5;
    private final double SPEED_REDUCTION = 0.35;
    private final class_1322 slownessModifier = new class_1322(this.SLOWNESS_ID, "slow", -0.35, class_1322.class_1323.field_6330);
    private final class_1322 heartModifier = new class_1322(this.MAX_HEALTH_ID, "short-heart", -0.5, class_1322.class_1323.field_6330);

    public static class_3414 getRandomSound(class_5819 random, IRegen cap) {
        class_3414[] soundEvents = cap.transitionType().getRegeneratingSounds();
        return soundEvents[random.method_43048(soundEvents.length)];
    }

    @Override
    public void onRegenTick(IRegen cap) {
        class_1309 livingEntity = cap.getLiving();
        float stateProgress = (float)cap.stateManager().stateProgress();
        switch (cap.regenState()) {
            case POST: {
                class_6885.class_6888 mobEffects = (class_6885.class_6888)class_7923.field_41174.method_40266(RegenUtil.POST_REGEN_POTIONS).get();
                if (livingEntity.field_6012 % 210 == 0 && !PlayerUtil.isPlayerAboveZeroGrid(livingEntity)) {
                    mobEffects.method_40243(class_5819.method_43047()).ifPresent(mobEffectHolder -> PlayerUtil.applyPotionIfAbsent(livingEntity, (class_1291)mobEffectHolder.comp_349(), livingEntity.method_37908().field_9229.method_43048(400), 1, false, false));
                }
                if (!PlayerUtil.isPlayerAboveZeroGrid(livingEntity)) break;
                PlayerUtil.handleZeroGrid(livingEntity);
                break;
            }
            case REGENERATING: {
                if (livingEntity instanceof class_3222) {
                    class_3222 playerEntity = (class_3222)livingEntity;
                    TriggerManager.FIRST_REGENERATION.trigger(playerEntity);
                }
                float dm = Math.max(1.0f, (float)(livingEntity.method_37908().method_8407().method_5461() + 1) / 3.0f);
                livingEntity.method_6025(stateProgress * 0.3f * dm);
                livingEntity.method_6097(0);
                class_238 box = livingEntity.method_5829().method_1014(25.0);
                Iterator iterator = class_2338.method_20437((class_2338)new class_2338((int)box.field_1320, (int)box.field_1325, (int)box.field_1324), (class_2338)new class_2338((int)box.field_1323, (int)box.field_1322, (int)box.field_1321)).iterator();
                while (iterator.hasNext()) {
                    BioContainerBlockEntity bioContainerBlockEntity;
                    class_2338 pos = (class_2338)iterator.next();
                    class_3218 serverWorld = (class_3218)livingEntity.method_37908();
                    class_2680 blockState = serverWorld.method_8320(pos);
                    if (!(blockState.method_26204() instanceof JarBlock) || !(bioContainerBlockEntity = (BioContainerBlockEntity)serverWorld.method_8321(pos)).isValid(BioContainerBlockEntity.Action.ADD)) continue;
                    if (livingEntity.method_37908().field_9229.method_43056() && serverWorld.method_8510() % 5L == 0L) {
                        bioContainerBlockEntity.setLindos(bioContainerBlockEntity.getLindos() + 0.7f);
                    }
                    bioContainerBlockEntity.sendUpdates();
                    return;
                }
                break;
            }
            case GRACE_CRIT: {
                float nauseaPercentage = 0.5f;
                if (stateProgress > nauseaPercentage) {
                    PlayerUtil.applyPotionIfAbsent(livingEntity, class_1294.field_5916, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - nauseaPercentage) * 1.5f), 0, false, false);
                }
                PlayerUtil.applyPotionIfAbsent(livingEntity, class_1294.field_5911, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - stateProgress)), 0, false, false);
                if (!(livingEntity.method_37908().field_9229.method_43058() < (double)((float)((Integer)RegenConfig.COMMON.criticalDamageChance.get()).intValue() / 100.0f))) break;
                livingEntity.method_5643(new class_1282(RegenDamageTypes.getHolder(livingEntity, RegenDamageTypes.REGEN_DMG_CRITICAL)), livingEntity.method_37908().field_9229.method_43057() + 0.5f);
                break;
            }
            case GRACE: {
                float weaknessPercentage = 0.5f;
                if (!(stateProgress > weaknessPercentage)) break;
                PlayerUtil.applyPotionIfAbsent(livingEntity, class_1294.field_5911, (int)((float)((Integer)RegenConfig.COMMON.gracePhaseLength.get() * 20) * (1.0f - weaknessPercentage) + (float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20)), 0, false, false);
                break;
            }
            case ALIVE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + cap.regenState());
            }
        }
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        class_1309 player = cap.getLiving();
        PlayerUtil.explodeKnockback((class_1297)player, player.method_37908(), player.method_24515(), (Double)RegenConfig.COMMON.regenerativeKnockback.get() / 2.0, (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        player.method_6073(player.method_6063() * 0.5f);
        if (!player.method_5996(class_5134.field_23716).method_6196(this.heartModifier)) {
            player.method_5996(class_5134.field_23716).method_26837(this.heartModifier);
        }
        player.method_6033(player.method_6063());
        WatcherTransition.createWatcher(player);
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        PlayerUtil.sendMessage(cap.getLiving(), class_2561.method_43471((String)RMessages.PUNCH_WARNING), true);
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (!cap.getLiving().method_5996(class_5134.field_23719).method_6196(this.slownessModifier)) {
            cap.getLiving().method_5996(class_5134.field_23719).method_26837(this.slownessModifier);
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        class_1309 player = cap.getLiving();
        player.method_6092(new class_1293(class_1294.field_5924, ((Integer)RegenConfig.COMMON.postRegenerationDuration.get()).intValue(), (Integer)RegenConfig.COMMON.postRegenerationLevel.get() - 1, false, false));
        player.method_6033(player.method_6063());
        player.method_6073((float)((Integer)RegenConfig.COMMON.absorbtionLevel.get() * 2));
        cap.setNextSkin(new byte[0]);
        player.method_5996(class_5134.field_23716).method_6202(this.heartModifier);
        player.method_5996(class_5134.field_23719).method_6202(this.slownessModifier);
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        class_1309 living = cap.getLiving();
        new SFXMessage(CommonActing.getRandomSound(living.method_6051(), cap).method_14833(), living.method_5628()).sendToDimension(living.method_37908());
        living.method_5996(class_5134.field_23716).method_6200(this.MAX_HEALTH_ID);
        living.method_5996(class_5134.field_23719).method_6200(this.SLOWNESS_ID);
        living.method_6033(Math.max(living.method_6032(), 8.0f));
        living.method_6073(0.0f);
        living.method_5646();
        living.method_5772();
        living.method_6012();
        living.method_5848();
        if (living instanceof class_1657) {
            class_1657 playerEntity = (class_1657)living;
            if (((Boolean)RegenConfig.COMMON.resetHunger.get()).booleanValue()) {
                playerEntity.method_7344().method_7580(20);
            }
        }
        if (((Boolean)RegenConfig.COMMON.resetOxygen.get()).booleanValue()) {
            living.method_5855(300);
        }
        cap.extractRegens(1);
        cap.getCurrentTrait().onRemoved(living, cap);
        if (cap.getNextTrait() != TraitRegistry.HUMAN.get()) {
            cap.setCurrentTrait(cap.getNextTrait());
            cap.setNextTrait(TraitRegistry.HUMAN.get());
        } else {
            TraitRegistry.getRandomTrait().ifPresent(cap::setCurrentTrait);
        }
        cap.getCurrentTrait().onAdded(living, cap);
        cap.syncToClients(null);
    }
}

