/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.regen.acting;

import java.io.File;
import mc.craig.software.regen.Regeneration;
import mc.craig.software.regen.client.skin.SkinRetriever;
import mc.craig.software.regen.client.skin.VisualManipulator;
import mc.craig.software.regen.common.item.ChaliceItem;
import mc.craig.software.regen.common.objects.REntities;
import mc.craig.software.regen.common.objects.RItems;
import mc.craig.software.regen.common.objects.RSounds;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.acting.Acting;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.traits.trait.TraitBase;
import mc.craig.software.regen.config.RegenConfig;
import mc.craig.software.regen.network.messages.SkinMessage;
import mc.craig.software.regen.util.ClientUtil;
import mc.craig.software.regen.util.RegenUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class ClientActing
implements Acting {
    public static final Acting INSTANCE = new ClientActing();

    @Override
    public void onRegenTick(IRegen cap) {
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        if (!class_310.method_1551().field_1724.method_5667().equals(cap.getLiving().method_5667())) {
            return;
        }
        class_3414 ambientSound = cap.getTimelordSound().getSound();
        ClientUtil.playSound(cap.getLiving(), class_7923.field_41172.method_10221((Object)RSounds.HEART_BEAT.get()), class_3419.field_15248, true, () -> !cap.regenState().isGraceful(), 0.2f, cap.getLiving().method_6051());
        ClientUtil.playSound(cap.getLiving(), class_7923.field_41172.method_10221((Object)ambientSound), class_3419.field_15256, true, () -> cap.regenState() != RegenStates.GRACE, 1.5f, cap.getLiving().method_6051());
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        if (cap.getLiving().method_5864() == class_1299.field_6097) {
            ClientUtil.playSound(cap.getLiving(), class_7923.field_41172.method_10221((Object)RSounds.HAND_GLOW.get()), class_3419.field_15248, true, () -> !cap.glowing(), 1.0f, cap.getLiving().method_6051());
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        if (!class_310.method_1551().field_1724.method_5667().equals(cap.getLiving().method_5667())) {
            return;
        }
        TraitBase trait = cap.getCurrentTrait();
        class_1799 chaliceStack = new class_1799((class_1935)RItems.GAUNTLET.get());
        ChaliceItem.setTrait(chaliceStack, trait);
        class_310.method_1551().field_1773.method_3189(chaliceStack);
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        if (!class_310.method_1551().field_1724.method_5667().equals(cap.getLiving().method_5667())) {
            return;
        }
        if (!((Boolean)RegenConfig.CLIENT.changeMySkin.get()).booleanValue()) {
            VisualManipulator.sendResetMessage();
            return;
        }
        if (cap.isNextSkinValid()) {
            new SkinMessage(cap.nextSkin(), cap.isNextSkinTypeAlex()).send();
            Regeneration.LOGGER.info("Skin chosen from saved data");
            return;
        }
        class_310.method_1551().method_20493(() -> {
            if (!cap.isNextSkinValid()) {
                File file = SkinRetriever.chooseRandomSkin(cap.getLiving().method_6051(), cap.getLiving().method_5864() == REntities.TIMELORD.get(), cap.preferredModel().isAlex());
                boolean isAlex = file.getAbsolutePath().contains("slim");
                Regeneration.LOGGER.info("Chosen Skin: {} - Slim Model: {}", (Object)file.getAbsolutePath(), (Object)isAlex);
                new SkinMessage(RegenUtil.fileToBytes(file), isAlex).send();
            }
        });
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (class_310.method_1551().field_1724.method_5667().equals(cap.getLiving().method_5667()) && cap.getLiving().method_5864() == class_1299.field_6097) {
            ClientUtil.createToast(class_2561.method_43471((String)"toast.regen.enter_critical"), class_2561.method_43469((String)"toast.regen.enter_critical.sub", (Object[])new Object[]{(Integer)RegenConfig.COMMON.criticalPhaseLength.get() / 60}));
            ClientUtil.playSound(cap.getLiving(), class_7923.field_41172.method_10221((Object)RSounds.CRITICAL_STAGE.get()), class_3419.field_15248, true, () -> cap.regenState() != RegenStates.GRACE_CRIT, 1.0f, class_5819.method_43047());
        }
    }
}

