/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.regen.acting;

import java.util.ArrayList;
import java.util.List;
import mc.craig.software.regen.common.regen.RegenerationData;
import mc.craig.software.regen.common.regen.acting.Acting;
import mc.craig.software.regen.common.regen.acting.ClientActing;
import mc.craig.software.regen.common.regen.acting.CommonActing;
import mc.craig.software.regen.network.messages.StateMessage;

public class ActingForwarder {
    private static final List<Acting> SERVER_HANDLERS = new ArrayList<Acting>();
    private static final List<Acting> CLIENT_HANDLERS = new ArrayList<Acting>();

    public static void init(boolean isClient) {
        ActingForwarder.register(CommonActing.INSTANCE, Side.COMMON);
        if (isClient) {
            ActingForwarder.register(ClientActing.INSTANCE, Side.CLIENT);
        }
    }

    public static void register(Class<? extends Acting> handlerClass, Side side) {
        try {
            ActingForwarder.register(handlerClass.newInstance(), side);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Error while instantiating acting handler", e);
        }
    }

    public static void register(Acting handler, Side side) {
        (side == Side.CLIENT ? CLIENT_HANDLERS : SERVER_HANDLERS).add(handler);
    }

    public static void onRegenTick(RegenerationData cap) {
        if (cap.getLiving().method_37908().field_9236) {
            throw new IllegalStateException("'Posting' tick `event` from client (this is VERY wrong)");
        }
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenTick(cap);
        }
    }

    public static void onEnterGrace(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.ENTER_GRACE);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onEnterGrace(cap);
        }
    }

    public static void onRegenFinish(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_FINISH);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenFinish(cap);
        }
    }

    public static void onRegenTrigger(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.REGEN_TRIGGER);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onRegenTrigger(cap);
        }
    }

    public static void onGoCritical(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.CRITICAL_START);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onGoCritical(cap);
        }
    }

    public static void onHandsStartGlowing(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.HAND_GLOW_START);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onHandsStartGlowing(cap);
        }
    }

    public static void onPerformingPost(RegenerationData cap) {
        ActingForwarder.checkAndForward(cap, RegenEvent.PERFORM_POST);
        for (Acting handler : SERVER_HANDLERS) {
            handler.onPerformingPost(cap);
        }
    }

    public static void onClient(RegenEvent event, RegenerationData cap) {
        for (Acting handler : CLIENT_HANDLERS) {
            switch (event) {
                case ENTER_GRACE: {
                    handler.onEnterGrace(cap);
                    break;
                }
                case REGEN_FINISH: {
                    handler.onRegenFinish(cap);
                    break;
                }
                case REGEN_TRIGGER: {
                    handler.onRegenTrigger(cap);
                    break;
                }
                case CRITICAL_START: {
                    handler.onGoCritical(cap);
                    break;
                }
                case HAND_GLOW_START: {
                    handler.onHandsStartGlowing(cap);
                    break;
                }
                case PERFORM_POST: {
                    handler.onPerformingPost(cap);
                }
            }
        }
    }

    private static void checkAndForward(RegenerationData cap, RegenEvent event) {
        if (cap.getLiving().method_37908().field_9236) {
            throw new IllegalStateException("'Posting' \"acting\" `event` from client");
        }
        new StateMessage(cap.getLiving(), event).sendToAll();
    }

    public static enum Side {
        COMMON,
        CLIENT;

    }

    public static enum RegenEvent {
        ENTER_GRACE,
        REGEN_FINISH,
        REGEN_TRIGGER,
        CRITICAL_START,
        PERFORM_POST,
        HAND_GLOW_START;

    }
}

