/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.regen.common.regen;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mc.craig.software.regen.common.advancement.TriggerManager;
import mc.craig.software.regen.common.regen.IRegen;
import mc.craig.software.regen.common.regen.acting.ActingForwarder;
import mc.craig.software.regen.common.regen.fabric.RegenerationDataImpl;
import mc.craig.software.regen.common.regen.state.IStateManager;
import mc.craig.software.regen.common.regen.state.RegenStates;
import mc.craig.software.regen.common.regen.transitions.TransitionType;
import mc.craig.software.regen.common.regen.transitions.TransitionTypes;
import mc.craig.software.regen.common.traits.TraitRegistry;
import mc.craig.software.regen.common.traits.trait.TraitBase;
import mc.craig.software.regen.config.RegenConfig;
import mc.craig.software.regen.network.messages.SyncMessage;
import mc.craig.software.regen.util.PlayerUtil;
import mc.craig.software.regen.util.RegenDamageTypes;
import mc.craig.software.regen.util.RegenUtil;
import mc.craig.software.regen.util.constants.RMessages;
import mc.craig.software.regen.util.schedule.RegenScheduledAction;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RegenerationData
implements IRegen {
    private final StateManager stateManager;
    private final class_1309 livingEntity;
    public class_7094 regen = new class_7094();
    public class_7094 grace = new class_7094();
    public boolean areHandsGlowing = false;
    public boolean nextSkinTypeAlex = false;
    public boolean isAlex = false;
    private boolean didSetup = false;
    private boolean traitActive = true;
    private int regensLeft = 0;
    private int animationTicks = 0;
    private byte[] nextSkin = new byte[0];
    private byte[] skinArray = new byte[0];
    private TransitionType transitionType = TransitionTypes.TRISTIS_IGNIS;
    private PlayerUtil.SkinType preferredSkinType = PlayerUtil.SkinType.ALEX;
    private RegenStates currentState = RegenStates.ALIVE;
    private IRegen.TimelordSound timelordSound = IRegen.TimelordSound.HUM;
    private IRegen.Hand handState = IRegen.Hand.NOT_CUT;
    private float primaryRed = 0.69411767f;
    private float primaryGreen = 0.74509805f;
    private float primaryBlue = 0.23529412f;
    private float secondaryRed = 0.7137255f;
    private float secondaryGreen = 0.75686276f;
    private float secondaryBlue = 0.25490198f;
    private TraitBase currentTrait;
    private TraitBase nextTrait = TraitRegistry.HUMAN.get();

    public RegenerationData() {
        this.livingEntity = null;
        this.stateManager = null;
    }

    public RegenerationData(class_1309 livingEntity) {
        this.livingEntity = livingEntity;
        this.nextTrait = TraitRegistry.HUMAN.get();
        this.currentTrait = TraitRegistry.HUMAN.get();
        this.stateManager = !livingEntity.method_37908().field_9236 ? new StateManager() : null;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<RegenerationData> get(class_1309 player) {
        return RegenerationDataImpl.get(player);
    }

    @Override
    public class_7094 getAnimationState(IRegen.RegenAnimation regenAnimation) {
        return switch (regenAnimation) {
            default -> throw new IncompatibleClassChangeError();
            case IRegen.RegenAnimation.GRACE -> this.grace;
            case IRegen.RegenAnimation.REGEN -> this.regen;
        };
    }

    @Override
    public int regens() {
        return this.regensLeft;
    }

    @Override
    public void setRegens(int regens) {
        this.regensLeft = regens;
    }

    @Override
    public void tick() {
        class_1309 class_13092;
        class_7094 regenAnimState = this.getAnimationState(IRegen.RegenAnimation.REGEN);
        class_7094 graceAnimState = this.getAnimationState(IRegen.RegenAnimation.GRACE);
        if (this.traitActive && this.getCurrentTrait() != null) {
            this.getCurrentTrait().tick(this.getLiving(), this);
        }
        if ((class_13092 = this.livingEntity) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (this.handState() != IRegen.Hand.NOT_CUT && !this.livingEntity.method_6079().method_7960()) {
                serverPlayer.method_5775(serverPlayer.method_6079().method_7972());
                serverPlayer.method_5673(class_1304.field_6171, class_1799.field_8037);
            }
            if (RegenUtil.shouldGiveCouncilAdvancement(serverPlayer)) {
                TriggerManager.COUNCIL.trigger(serverPlayer);
            }
        }
        if (this.regenState() == RegenStates.REGENERATING) {
            if (!regenAnimState.method_41327()) {
                regenAnimState.method_41322(this.livingEntity.field_6012);
            }
        } else {
            regenAnimState.method_41325();
        }
        if (this.regenState() == RegenStates.GRACE_CRIT) {
            if (!graceAnimState.method_41327()) {
                graceAnimState.method_41322(this.livingEntity.field_6012);
            }
        } else {
            graceAnimState.method_41325();
        }
        if (this.livingEntity.method_37908().field_9236) {
            return;
        }
        if (!this.didSetup) {
            this.syncToClients(null);
            this.didSetup = true;
        }
        if (this.stateManager != null && this.currentState != RegenStates.ALIVE) {
            this.stateManager.tick();
        }
        if (this.currentState == RegenStates.REGENERATING) {
            ++this.animationTicks;
            this.transitionType.onUpdateMidRegen(this);
            this.syncToClients(null);
            return;
        }
        this.animationTicks = 0;
    }

    @Override
    public int updateTicks() {
        return this.animationTicks;
    }

    @Override
    public void setUpdateTicks(int animationTicks) {
        this.animationTicks = animationTicks;
    }

    @Override
    public boolean canRegenerate() {
        if (this.livingEntity != null) {
            return this.regens() > 0 && this.livingEntity.method_23318() > (double)this.livingEntity.method_5770().method_31607() && this.currentState != RegenStates.POST;
        }
        return false;
    }

    @Override
    public boolean glowing() {
        return this.areHandsGlowing;
    }

    @Override
    public RegenStates regenState() {
        return this.currentState;
    }

    @Override
    public StateManager stateManager() {
        return this.stateManager;
    }

    @Override
    public void readStyle(class_2487 colors) {
        this.primaryRed = colors.method_10583("p_red");
        this.primaryGreen = colors.method_10583("p_green");
        this.primaryBlue = colors.method_10583("p_blue");
        this.secondaryRed = colors.method_10583("s_red");
        this.secondaryGreen = colors.method_10583("s_green");
        this.secondaryBlue = colors.method_10583("s_blue");
    }

    @Override
    public class_2487 getOrWriteStyle() {
        class_2487 colors = new class_2487();
        colors.method_10548("p_red", this.primaryRed);
        colors.method_10548("p_green", this.primaryGreen);
        colors.method_10548("p_blue", this.primaryBlue);
        colors.method_10548("s_red", this.secondaryRed);
        colors.method_10548("s_green", this.secondaryGreen);
        colors.method_10548("s_blue", this.secondaryBlue);
        return colors;
    }

    @Override
    public void extractRegens(int amount) {
        this.regensLeft -= amount;
    }

    @Override
    public void addRegens(int amount) {
        this.regensLeft += amount;
    }

    @Override
    public class_1309 getLiving() {
        return this.livingEntity;
    }

    @Override
    public void syncToClients(@Nullable class_3222 serverPlayerEntity) {
        if (this.livingEntity != null && this.livingEntity.method_37908().field_9236) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.areHandsGlowing = this.regenState().isGraceful() && this.stateManager.handGlowTimer.getTransition() == RegenStates.Transition.HAND_GLOW_TRIGGER;
        class_2487 nbt = this.serializeNBT();
        nbt.method_10551("state_manager");
        SyncMessage message = new SyncMessage(this.livingEntity.method_5628(), nbt);
        if (serverPlayerEntity == null) {
            message.sendToAll();
        } else {
            message.send(serverPlayerEntity);
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 compoundNBT = new class_2487();
        compoundNBT.method_10569("regens_left", this.regens());
        compoundNBT.method_10582("current_state", this.regenState().name());
        compoundNBT.method_10569("ticks_animating", this.updateTicks());
        if (this.transitionType == null) {
            this.transitionType = TransitionTypes.FIERY;
        } else {
            compoundNBT.method_10582("transition_type", TransitionTypes.getTransitionId(this.transitionType).toString());
        }
        compoundNBT.method_10582("model_pref", this.preferredModel().name());
        compoundNBT.method_10556("is_alex", this.currentlyAlex());
        compoundNBT.method_10556("glowing", this.glowing());
        compoundNBT.method_10582("sound_scheme", this.getTimelordSound().name());
        compoundNBT.method_10582("severed_state", this.handState().name());
        compoundNBT.method_10556("is_trait_active", this.traitActive);
        compoundNBT.method_10556("next_is_alex", this.isNextSkinTypeAlex());
        if (this.currentTrait != null) {
            compoundNBT.method_10582("current_trait", TraitRegistry.TRAITS_REGISTRY.getKey(this.currentTrait).toString());
        }
        if (this.nextTrait != null) {
            compoundNBT.method_10582("next_trait", TraitRegistry.TRAITS_REGISTRY.getKey(this.nextTrait).toString());
        }
        if (this.isSkinValidForUse()) {
            compoundNBT.method_10570("skin", this.skin());
        }
        if (this.isNextSkinValid()) {
            compoundNBT.method_10570("next_skin", this.nextSkin());
        }
        if (!this.livingEntity.method_37908().field_9236 && this.stateManager != null) {
            compoundNBT.method_10566("state_manager", (class_2520)this.stateManager.serializeNBT());
        }
        compoundNBT.method_10566("colors", (class_2520)this.getOrWriteStyle());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.setRegens(nbt.method_10550("regens_left"));
        this.currentState = nbt.method_10545("current_state") ? RegenStates.valueOf(nbt.method_10558("current_state")) : RegenStates.ALIVE;
        this.setUpdateTicks(nbt.method_10550("ticks_animating"));
        this.setSkin(nbt.method_10547("skin"));
        this.setNextSkin(nbt.method_10547("next_skin"));
        this.setAlexSkin(nbt.method_10577("is_alex"));
        this.traitActive = nbt.method_10577("is_trait_active");
        this.setNextSkinType(nbt.method_10577("next_is_alex"));
        if (nbt.method_10545("sound_scheme")) {
            this.setTimelordSound(IRegen.TimelordSound.valueOf(nbt.method_10558("sound_scheme")));
        }
        if (nbt.method_10545("severed_state")) {
            this.setHandState(IRegen.Hand.valueOf(nbt.method_10558("severed_state")));
        }
        this.areHandsGlowing = nbt.method_10577("glowing");
        if (nbt.method_10545("model_pref")) {
            this.setPreferredModel(PlayerUtil.SkinType.valueOf(nbt.method_10558("model_pref")));
        }
        if (nbt.method_10545("transition_type")) {
            this.transitionType = TransitionTypes.TRANSITION_TYPES.get(new class_2960(nbt.method_10558("transition_type")));
        }
        this.setCurrentTrait(TraitRegistry.TRAITS_REGISTRY.get(new class_2960(nbt.method_10558("current_trait"))));
        this.setNextTrait(TraitRegistry.TRAITS_REGISTRY.get(new class_2960(nbt.method_10558("next_trait"))));
        if (nbt.method_10545("state_manager") && this.stateManager != null) {
            this.stateManager.deserializeNBT((class_2487)nbt.method_10580("state_manager"));
        }
        if (nbt.method_10545("colors")) {
            this.readStyle((class_2487)nbt.method_10580("colors"));
        }
    }

    @Override
    public TransitionType transitionType() {
        return this.transitionType;
    }

    @Override
    public void setTransitionType(TransitionType transitionType) {
        this.transitionType = transitionType;
    }

    @Override
    public void forceRegeneration() {
        if (this.livingEntity != null) {
            this.livingEntity.method_6078(new class_1282(RegenDamageTypes.getHolder(this.livingEntity, RegenDamageTypes.REGEN_DMG_FORCED)));
        }
    }

    @Override
    public byte[] skin() {
        return this.skinArray;
    }

    @Override
    public void setSkin(byte[] skin) {
        this.skinArray = skin;
    }

    @Override
    public boolean isSkinValidForUse() {
        return !Arrays.equals(this.skinArray, new byte[0]);
    }

    @Override
    public class_243 getPrimaryColors() {
        return new class_243((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public class_243 getSecondaryColors() {
        return new class_243((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public boolean currentlyAlex() {
        return this.isAlex;
    }

    @Override
    public void setAlexSkin(boolean isAlex) {
        this.isAlex = isAlex;
    }

    @Override
    public PlayerUtil.SkinType preferredModel() {
        return this.preferredSkinType;
    }

    @Override
    public void setPreferredModel(PlayerUtil.SkinType skinType) {
        this.preferredSkinType = skinType;
    }

    @Override
    public byte[] nextSkin() {
        return this.nextSkin;
    }

    @Override
    public void setNextSkin(byte[] bytes) {
        this.nextSkin = bytes;
    }

    @Override
    public boolean isNextSkinValid() {
        return !Arrays.equals(this.nextSkin, new byte[0]);
    }

    @Override
    public void setNextSkinType(boolean isAlex) {
        this.nextSkinTypeAlex = isAlex;
    }

    @Override
    public boolean isNextSkinTypeAlex() {
        return this.nextSkinTypeAlex;
    }

    @Override
    public IRegen.TimelordSound getTimelordSound() {
        return this.timelordSound;
    }

    @Override
    public void setTimelordSound(IRegen.TimelordSound timelordSound) {
        this.timelordSound = timelordSound;
    }

    @Override
    public IRegen.Hand handState() {
        return this.handState;
    }

    @Override
    public void setHandState(IRegen.Hand handState) {
        this.handState = handState;
    }

    @Override
    public boolean isTraitActive() {
        return this.traitActive;
    }

    @Override
    public void toggleTrait() {
        this.traitActive = !this.traitActive;
    }

    @Override
    public TraitBase getCurrentTrait() {
        return this.currentTrait;
    }

    @Override
    public void setCurrentTrait(TraitBase trait) {
        this.currentTrait = trait;
    }

    @Override
    public TraitBase getNextTrait() {
        return this.nextTrait;
    }

    @Override
    public void setNextTrait(TraitBase trait) {
        this.nextTrait = trait;
    }

    public class StateManager
    implements IStateManager {
        private final Map<RegenStates.Transition, Runnable> transitionCallbacks = new HashMap<RegenStates.Transition, Runnable>();
        private RegenScheduledAction nextTransition;
        private RegenScheduledAction handGlowTimer;

        private StateManager() {
            this.transitionCallbacks.put(RegenStates.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(RegenStates.Transition.CRITICAL_DEATH, () -> this.midSequenceKill(true));
            this.transitionCallbacks.put(RegenStates.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(RegenStates.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(RegenStates.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + RegenerationData.this.livingEntity.method_5477());
            }
            if (transition == RegenStates.Transition.HAND_GLOW_START || transition == RegenStates.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new RegenScheduledAction(transition, RegenerationData.this.livingEntity, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(RegenStates.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (RegenerationData.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_START, RegenerationData.this.livingEntity, this::scheduleHandGlowTrigger, (Integer)RegenConfig.COMMON.handGlowInterval.get() * 20);
            RegenerationData.this.syncToClients(null);
        }

        private void scheduleHandGlowTrigger() {
            if (RegenerationData.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_TRIGGER, RegenerationData.this.livingEntity, this::triggerRegeneration, (Integer)RegenConfig.COMMON.handGlowTriggerDelay.get() * 20);
            ActingForwarder.onHandsStartGlowing(RegenerationData.this);
            RegenerationData.this.syncToClients(null);
        }

        @Override
        public boolean onKilled(class_1282 source) {
            if (source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42341)) {
                return false;
            }
            if (source.method_49708(RegenDamageTypes.REGEN_DMG_CRITICAL)) {
                if (this.nextTransition != null) {
                    this.nextTransition.cancel();
                }
                return false;
            }
            switch (RegenerationData.this.currentState) {
                case ALIVE: {
                    if (!RegenerationData.this.canRegenerate()) {
                        return false;
                    }
                    this.scheduleTransitionInSeconds(RegenStates.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
                    this.scheduleHandGlowTrigger();
                    RegenerationData.this.currentState = RegenStates.GRACE;
                    RegenerationData.this.syncToClients(null);
                    ActingForwarder.onEnterGrace(RegenerationData.this);
                    return true;
                }
                case REGENERATING: {
                    this.nextTransition.cancel();
                    this.midSequenceKill(false);
                    return false;
                }
                case GRACE_CRIT: {
                    this.nextTransition.cancel();
                    if (source.method_49708(RegenDamageTypes.REGEN_DMG_FORCED)) {
                        this.triggerRegeneration();
                        return true;
                    }
                    this.midSequenceKill(true);
                    return false;
                }
                case POST: {
                    RegenerationData.this.currentState = RegenStates.ALIVE;
                    this.nextTransition.cancel();
                    return false;
                }
                case GRACE: {
                    this.triggerRegeneration();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean onPunchBlock(class_2338 pos, class_2680 blockState, class_1657 entity) {
            if (RegenerationData.this.currentState.isGraceful() && RegenerationData.this.glowing()) {
                if (blockState.method_26204() == class_2246.field_10477 || blockState.method_26204() == class_2246.field_10491) {
                    entity.method_37908().method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                }
                if (entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    class_3222 playerEntity = (class_3222)RegenerationData.this.livingEntity;
                    TriggerManager.CHANGE_REFUSAL.trigger(playerEntity);
                    PlayerUtil.sendMessage((class_1309)serverPlayer, class_2561.method_43471((String)RMessages.DELAYED_REGENERATION), true);
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                return true;
            }
            return false;
        }

        private void tick() {
            if (RegenerationData.this.livingEntity.method_37908().field_9236) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (RegenerationData.this.currentState == RegenStates.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (RegenerationData.this.currentState.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(RegenerationData.this);
            if (this.nextTransition != null) {
                this.nextTransition.tick();
            }
            if (RegenerationData.this.currentState == RegenStates.POST) {
                ActingForwarder.onPerformingPost(RegenerationData.this);
            }
        }

        private void enterGrace() {
            this.scheduleTransitionInSeconds(RegenStates.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
            this.scheduleHandGlowTrigger();
            RegenerationData.this.currentState = RegenStates.GRACE;
            RegenerationData.this.syncToClients(null);
            ActingForwarder.onEnterGrace(RegenerationData.this);
        }

        private void triggerRegeneration() {
            RegenerationData.this.currentState = RegenStates.REGENERATING;
            if (((Boolean)RegenConfig.COMMON.sendRegenDeathMessages.get()).booleanValue() && RegenerationData.this.livingEntity instanceof class_1657) {
                class_5250 text = class_2561.method_43469((String)RMessages.REGENERATION_DEATH_MSG, (Object[])new Object[]{RegenerationData.this.livingEntity.method_5477()});
                if (RegenerationData.this.livingEntity.method_6081() != null) {
                    text.method_10862(text.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)RegenerationData.this.livingEntity.method_6081().method_5506(RegenerationData.this.livingEntity))));
                }
                PlayerUtil.globalMessage((class_2561)text, Objects.requireNonNull(RegenerationData.this.livingEntity.method_5682()));
            }
            this.nextTransition.cancel();
            if (RegenerationData.this.currentState.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(RegenStates.Transition.FINISH_REGENERATION, RegenerationData.this.transitionType.getAnimationLength());
            ActingForwarder.onRegenTrigger(RegenerationData.this);
            RegenerationData.this.transitionType.onStartRegeneration(RegenerationData.this);
            RegenerationData.this.syncToClients(null);
        }

        private void enterCriticalPhase() {
            RegenerationData.this.currentState = RegenStates.GRACE_CRIT;
            this.scheduleTransitionInSeconds(RegenStates.Transition.CRITICAL_DEATH, ((Integer)RegenConfig.COMMON.criticalPhaseLength.get()).intValue());
            ActingForwarder.onGoCritical(RegenerationData.this);
            class_1309 class_13092 = RegenerationData.this.livingEntity;
            if (class_13092 instanceof class_3222) {
                class_3222 playerEntity = (class_3222)class_13092;
                TriggerManager.CRITICAL.trigger(playerEntity);
            }
            RegenerationData.this.syncToClients(null);
        }

        private void midSequenceKill(boolean isGrace) {
            RegenerationData.this.currentState = RegenStates.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            RegenerationData.this.transitionType.onFinishRegeneration(RegenerationData.this);
            RegenerationData.this.livingEntity.method_5643(isGrace ? new class_1282(RegenDamageTypes.getHolder(RegenerationData.this.livingEntity, RegenDamageTypes.REGEN_DMG_CRITICAL)) : new class_1282(RegenDamageTypes.getHolder(RegenerationData.this.livingEntity, RegenDamageTypes.REGEN_DMG_KILLED)), 2.1474836E9f);
            if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                RegenerationData.this.extractRegens(RegenerationData.this.regens());
            }
            RegenerationData.this.setCurrentTrait(TraitRegistry.HUMAN.get());
            RegenerationData.this.setSkin(new byte[0]);
            RegenerationData.this.syncToClients(null);
        }

        private void endPost() {
            RegenerationData.this.currentState = RegenStates.ALIVE;
            this.nextTransition = null;
            if (RegenerationData.this.livingEntity instanceof class_1657) {
                PlayerUtil.sendMessage(RegenerationData.this.livingEntity, class_2561.method_43471((String)RMessages.END_OF_PROCESS), true);
            }
            RegenerationData.this.handState = IRegen.Hand.NOT_CUT;
            RegenerationData.this.syncToClients(null);
        }

        private void finishRegeneration() {
            RegenerationData.this.currentState = RegenStates.POST;
            this.scheduleTransitionInSeconds(RegenStates.Transition.END_POST, RegenerationData.this.livingEntity.method_37908().field_9229.method_43048(300) + 10);
            this.handGlowTimer = null;
            RegenerationData.this.transitionType.onFinishRegeneration(RegenerationData.this);
            ActingForwarder.onRegenFinish(RegenerationData.this);
            RegenerationData.this.syncToClients(null);
        }

        @Override
        @Deprecated
        public Pair<RegenStates.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void skip() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double stateProgress() {
            if (this.nextTransition != null) {
                return this.nextTransition.getProgress();
            }
            return 0.0;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 nbt = new class_2487();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.method_10582("transitionId", this.nextTransition.transition.toString());
                nbt.method_10544("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.method_10582("handGlowState", this.handGlowTimer.transition.toString());
                nbt.method_10544("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        @Override
        public void deserializeNBT(class_2487 nbt) {
            if (nbt.method_10545("transitionId")) {
                this.scheduleTransitionInTicks(RegenStates.Transition.valueOf(nbt.method_10558("transitionId")), nbt.method_10537("transitionInTicks"));
            }
            if (nbt.method_10545("handGlowState")) {
                RegenStates.Transition transition = RegenStates.Transition.valueOf(nbt.method_10558("handGlowState"));
                Runnable callback = switch (transition) {
                    case RegenStates.Transition.HAND_GLOW_START -> this::scheduleHandGlowTrigger;
                    case RegenStates.Transition.HAND_GLOW_TRIGGER -> this::triggerRegeneration;
                    default -> throw new IllegalStateException("Illegal hand glow timer transition");
                };
                this.handGlowTimer = new RegenScheduledAction(transition, RegenerationData.this.livingEntity, callback, nbt.method_10537("handGlowScheduledTicks"));
            }
        }
    }
}

